package ru.yandex.autotests.directapi.darkside.enums;

import com.yandex.direct.api.v5.general.MobileAppAdActionEnum;
import ru.yandex.autotests.directapi.enums.PrimaryAction;

/**
 * Created by alexteut on 08.09.16.
 */
public enum AdActionObjectType {
    DOWNLOAD(MobileAppAdActionEnum.DOWNLOAD, PrimaryAction.DOWNLOAD),
    UPDATE(MobileAppAdActionEnum.UPDATE, PrimaryAction.UPDATE),
    PLAY(MobileAppAdActionEnum.PLAY, PrimaryAction.PLAY),
    GET(MobileAppAdActionEnum.GET, PrimaryAction.GET),
    INSTALL(MobileAppAdActionEnum.INSTALL, PrimaryAction.INSTALL),
    MORE(MobileAppAdActionEnum.MORE, PrimaryAction.MORE),
    OPEN(MobileAppAdActionEnum.OPEN, PrimaryAction.OPEN),
    // BUY_AUTODETECT показывают в зависимости от типа приложения:
    // если бесплатное, то скачать
    // если платное, то купить.
    BUY(MobileAppAdActionEnum.BUY_AUTODETECT, PrimaryAction.BUY);

    private MobileAppAdActionEnum mobileAppAdAction;
    private PrimaryAction primaryAction;

    AdActionObjectType(MobileAppAdActionEnum mobileAppAdAction, PrimaryAction primaryAction) {
        this.mobileAppAdAction = mobileAppAdAction;
        this.primaryAction = primaryAction;
    }

    public MobileAppAdActionEnum getMobileAppAdAction() {
        return mobileAppAdAction;
    }

    public PrimaryAction getPrimaryAction() {
        return primaryAction;
    }

    @Override
    public String toString() {
        return primaryAction.toString();
    }
}
