package ru.yandex.autotests.directapi.darkside.exceptions;

/**
 * User: mariabye
 * Date: 13.02.12
 * Exception, выбрасываемый в случае неожиданных ошибок, не связанных
 * непосредственно с тестовым сценарием. Например,
 * ошибки тестовой среды
 * ошибки в тестах
 */
public class DarkSideException extends RuntimeException {
    String mistake = "Ошибка запроса к сервису (INTAPI)";

    public DarkSideException() {
        super();             // call superclass constructor
        mistake = "unknown";
    }

    public DarkSideException(String err) {
        super(err);     // call super class constructor
        mistake = err;  // save message
    }

    public DarkSideException(String message, Throwable e) {
        super(message, e);
    }

    public DarkSideException(Exception e) {
        super(e);
    }
}
