package ru.yandex.autotests.directapi.darkside.model;

import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.AdgroupsMobileContentRecord;
import ru.yandex.autotests.directapi.darkside.model.bslogs.mobile.OSVersions;
import ru.yandex.autotests.directapi.enums.DeviceTargeting;
import ru.yandex.autotests.directapi.enums.NetworkTargeting;

/**
 * Created by semkagtn on 14.09.15.
 */
public class AdgroupsMobileContentUtils {

    private static final String DEFAULT_TRACKING_LINK
            = "https://play.google.com/store/apps/details?id=ru.yandex.searchplugin";

    public static AdgroupsMobileContentRecord getDefaultAdgroupsMobileContent(long pid, long mobileContentId) {
        AdgroupsMobileContentRecord adgroupsMobileContentRecord = new AdgroupsMobileContentRecord()
                .setPid(pid)
                .setMobileContentId(mobileContentId)
                .setMinOsVersion(OSVersions.IOS_VERSIONS[1])
                .setNetworkTargeting(NetworkTargeting.WIFI.toString())
                .setDeviceTypeTargeting(DeviceTargeting.PHONE.toString())
                .setStoreContentHref(DEFAULT_TRACKING_LINK);
        return adgroupsMobileContentRecord;
    }

    private AdgroupsMobileContentUtils() {

    }
}
