package ru.yandex.autotests.directapi.darkside.model;

import java.util.ArrayList;
import java.util.List;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import one.util.streamex.StreamEx;

import ru.yandex.autotests.directapi.darkside.model.multipliers.DirectAtom;
import ru.yandex.autotests.irt.testutils.json.JsonUtils;

public class BidMultiplierConditionBuilder {

    private List<List<DirectAtom>> andArray = new ArrayList<>();

    public static BidMultiplierConditionBuilder init() {
        return new BidMultiplierConditionBuilder();
    }

    public BidMultiplierConditionBuilder and(DirectAtom... atoms ){
        andArray.add(StreamEx.of(atoms).toList());
        return this;
    }

    public List<List<DirectAtom>> build() {
        return andArray;
    }

    public JsonElement buildJsonElement() {
        return new Gson().toJsonTree(andArray);
    }

    public String toString() {
        return JsonUtils.toLowCaseString(andArray);
    }

}


