package ru.yandex.autotests.directapi.darkside.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;

/**
 * Created by hmepas on 28.03.17
 */
public class ClientsCreateError {
    private final Integer code;
    private final String name;
    private final String message;
    private final ErrorEnum error;

    public ClientsCreateError(ErrorEnum error) {
        this(error, "");
    }

    public ClientsCreateError(ErrorEnum error, String message) {
        this.error = error;
        this.code = error.ERROR_CODE;
        this.name = error.ERROR_NAME;
        this.message = message;
    }

    public ClientsCreateError(Integer errorCode, String message) {
        this(ErrorEnum.byCode(errorCode), message);
    }

    public ClientsCreateError(Integer errorCode) {
        this(errorCode, "");
    }

    public Integer getCode() {
        return code;
    }

    public String getName() {
        return name;
    }

    public String getMessage() {
        return message;
    }

    public ErrorEnum getErrorEnum() {
        return error;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ClientsCreateError)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (this.error.equals(((ClientsCreateError) obj).getErrorEnum())
                && this.message.equals(((ClientsCreateError) obj).getMessage())) {
            return true;
        }
        return false;
    }

    public enum ErrorEnum {
        BAD_REQUEST (400, "BadRequest");

        private final int ERROR_CODE;
        private final String ERROR_NAME;

        ErrorEnum(int code, String error) {
            this.ERROR_CODE = code;
            this.ERROR_NAME = error;
        }

        public String getErrorName() {
            return this.ERROR_NAME;
        }
        public int getErrorCode() {
            return this.ERROR_CODE;
        }

        public static Collection<Integer> errorCodes() {
            return Arrays.stream(values()).map(e -> e.getErrorCode()).collect(Collectors.toList());
        }

        public static Collection<Integer> errorNames() {
            return Arrays.stream(values()).map(e -> e.getErrorCode()).collect(Collectors.toList());
        }

        public static ErrorEnum byName(String errorName) {
            for (ErrorEnum e : ErrorEnum.values()) {
                if (e.ERROR_NAME.equals(errorName)) {
                    return e;
                }
            }
            throw new IllegalArgumentException("No error with name " + errorName + " exists");
        }

        public static ErrorEnum byCode(int code) {
            for (ErrorEnum e : ErrorEnum.values()) {
                if (e.ERROR_CODE == code) {
                    return e;
                }
            }
            throw new IllegalArgumentException("No error with code " + code + " exists");
        }
    }
}
