package ru.yandex.autotests.directapi.darkside.model;

import ru.yandex.autotests.directapi.darkside.datacontainers.DarksideTextConstants;

/**
 * Created by buhter on 01.06.16.
 */
public enum FeedsErrorsEnum {

    BL_ERROR_FETCH_FAILED(1201, DarksideTextConstants.BL_ERROR_FETCH_FAILED.getText()),
    BL_ERROR_YML_NO_MODEL_OR_TAG_NAME(1203, DarksideTextConstants.BL_ERROR_YML_NO_MODEL_OR_TAG_NAME.getText()),
    BL_ERROR_XML_FATAL(1204, DarksideTextConstants.BL_ERROR_XML_FATAL.getText()),
    BL_ERROR_XML_NO_OFFERS(1205, DarksideTextConstants.BL_ERROR_XML_NO_OFFERS.getText()),
    BL_ERROR_XML_NO_CATEGORIES(1206, DarksideTextConstants.BL_ERROR_XML_NO_CATEGORIES.getText()),
    BL_ERROR_YML_NO_URL_TAG(1207, DarksideTextConstants.BL_ERROR_YML_NO_URL_TAG.getText()),
    BL_ERROR_YML_EMPTY_FILE(1211, DarksideTextConstants.BL_ERROR_YML_EMPTY_FILE.getText()),
    BL_ERROR_FEED_DATA_TYPE_MISMATCH(1213, DarksideTextConstants.BL_ERROR_FEED_DATA_TYPE_MISMATCH.getText()),
    BL_ERROR_FILE_TOO_BIG(1266, DarksideTextConstants.BL_ERROR_FILE_TOO_BIG.getText()),
    BL_ERROR_FATAL(1812, DarksideTextConstants.BL_ERROR_FATAL.getText()),
    BL_ERROR_UNKNOWN(666, "Unknown error");

    private String message;
    private int code;

    FeedsErrorsEnum(int code, String message) {
        this.code = code;
        this.message = message;
    }

    public String getMessage() {
        return message;
    }

    public int getCode() {
        return code;
    }

    @Override
    public String toString() {
        return "FeedsErrorsEnum{" +
                "code=" + code +
                '}';
    }
}
