package ru.yandex.autotests.directapi.darkside.model;

import ru.yandex.autotests.directapi.beans.images.ImagesFormats;

/**
 * Связывает тип картинки со списком форматов для нее
 *
 * Вспомогательный класс (не используется непосредственно в ручках)
 */
public enum ImageType {

    /*
        От 150x150 до 449 по короткой стороне с соотношением сторон от 3:4 до 4:3
     */
    SMALL("small", ImagesFormats.SMALL),

    /*
        От 450 по короткой стороне до 5000x5000 с соотношением сторон от 3:4 до 4:3
     */
    REGULAR("regular", ImagesFormats.REGULAR),

    /*
        От 1080 по ширине до 5000 по ширине с соотношением сторон строго 16:9
     */
    WIDE("wide", ImagesFormats.WIDE);

    ImageType(String name, ImagesFormats imagesFormats) {
        this.name = name;
        this.imagesFormats = imagesFormats;
    }

    private String name;
    private ImagesFormats imagesFormats;

    public String getName() {
        return name;
    }

    public ImagesFormats getImagesFormats() {
        return imagesFormats;
    }

    @Override
    public String toString() {
        return name;
    }
}
