package ru.yandex.autotests.directapi.darkside.model;

import com.google.gson.Gson;
import org.apache.commons.lang3.RandomStringUtils;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.*;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.MobileContentRecord;
import ru.yandex.autotests.directapi.darkside.model.bslogs.mobile.CountryCurrencies;
import ru.yandex.autotests.directapi.darkside.model.bslogs.mobile.OSVersions;
import ru.yandex.autotests.directapi.darkside.model.bslogs.mobile.PriceInJson;
import ru.yandex.autotests.irt.testutils.RandomUtils;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by buhter on 18/08/15.
 */
public class MobileContentUtils {
    public static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormat.forPattern("yyyy-MM-dd HH:mm:ss");

    public static MobileContentRecord getDefaultMobileContent(String clientId) {
        MobileContentRecord mobileContent = new MobileContentRecord()
                .setClientid(Long.valueOf(clientId))
                .setStoreContentId("ru.yandex.autotests." + RandomStringUtils.randomAlphabetic(2) + RandomUtils.getString(8))
                .setStoreCountry(CountryCurrencies.US.country())
                .setOsType(MobileContentOsType.iOS)
                .setContentType(MobileContentContentType.app)
                .setBundleId("ru.yandex.autotests." + RandomStringUtils.randomAlphabetic(2) + RandomUtils.getString(8))
                .setIsAvailable(1)
                .setCreateTime(Timestamp.from(Instant.now()))
                .setModifyTime(Timestamp.from(Instant.now()))
                .setStatusbssynced(MobileContentStatusbssynced.No)
                .setName("ru.yandex.autotests" + RandomStringUtils.randomAlphabetic(2) + RandomUtils.getString(8))
                .setPricesJson(getPricesJsonFor(new CountryCurrencies[]{CountryCurrencies.US}))
                .setRating(BigDecimal.valueOf(RandomUtils.getRandomFloat(0, 5)).setScale(2, BigDecimal.ROUND_HALF_UP))
                .setRatingVotes((long) RandomUtils.getRandomInteger(0, Integer.MAX_VALUE))
                .setIconHash("23070/605c899a23e5ec8d7ace9e1dcaddd4e9")
                .setStatusiconmoderate(MobileContentStatusiconmoderate.Yes)
                .setMinOsVersion(OSVersions.IOS_VERSIONS[RandomUtils.getNextInt(OSVersions.IOS_VERSIONS.length)])
                .setAppSizeBytes((long) RandomUtils.getRandomInteger(0, Integer.MAX_VALUE))
                .setAvailableActions(BannersMobileContentPrimaryAction.download.getLiteral())
                .setPublisherDomainId(null)
                .setGenre("Music")
                .setAgeLabel(MobileContentAgeLabel._12_2b)
                .setTriesCount(0L);
        return mobileContent;
    }

    //Обязательно среди них должен быть download!
    //UPD: https://st/DIRECT-45013 - пока поддерживается ТОЛЬКО download
    public static String getPricesJsonFor(CountryCurrencies[] countryCurrencies) {
        Map<String, Map<String, PriceInJson>> pricesMap = new HashMap<>();
        Arrays.asList(countryCurrencies).forEach(countryCurrenciesItem -> {
            Map<String, PriceInJson> actionPricesMap = new HashMap<>();
            Arrays.asList(BannersMobileContentPrimaryAction.values()).forEach(availableActions -> {
                PriceInJson price = new PriceInJson();
                price.setPrice(BigDecimal.valueOf(RandomUtils.getRandomFloat(0, 15))
                        .setScale(2, BigDecimal.ROUND_HALF_UP)
                        .toString()
                );
                price.setPriceCurrency(countryCurrenciesItem.currency().value());
                actionPricesMap.put(availableActions.getLiteral(), price);
            });
            pricesMap.put(countryCurrenciesItem.country(), actionPricesMap);
        });

        return new Gson().toJson(pricesMap);
    }

    //Для получения данных с валютой неизвестной в Директе
    public static String getPricesJsonFor(Map<String, String> countryCurrencies) {
        Map<String, Map<String, PriceInJson>> pricesMap = new HashMap<>();
        countryCurrencies.forEach((country, currency) -> {
            Map<String, PriceInJson> actionPricesMap = new HashMap<>();
            PriceInJson price = new PriceInJson();
            price.setPrice(BigDecimal.valueOf(RandomUtils.getRandomFloat(0, 15)).setScale(2, BigDecimal.ROUND_HALF_UP)
                    .toString()
            );
            price.setPriceCurrency(currency);
            actionPricesMap.put(BannersMobileContentPrimaryAction.download.getLiteral(), price);
            pricesMap.put(country, actionPricesMap);
        });
        return new Gson().toJson(pricesMap);
    }
}
