package ru.yandex.autotests.directapi.darkside.model;

import ru.yandex.autotests.direct.db.models.jooq.ppcdict.enums.ModerateDiagsBadReason;
import ru.yandex.autotests.direct.db.models.jooq.ppcdict.enums.ModerateDiagsUnbanIsProhibited;

/**
 * Идентификаторы причин отклонения, используемые в тестах
 * Хранятся в таблице ppcdict.moderate_diags
 *
 * Делятся на категории по типу причины отклонения (грубая, допустимая), в соответствии с badReason = (Yes, No)
 */
public enum ModerateTestDiags {
    //грубые причины отклонения для фраз
    GROSS_REASON_1(1, ModerateDiagsBadReason.Yes, ModerateDiagsUnbanIsProhibited.No),
    GROSS_REASON_12(12, ModerateDiagsBadReason.Yes, ModerateDiagsUnbanIsProhibited.No),
    GROSS_REASON_137(137, ModerateDiagsBadReason.Yes, ModerateDiagsUnbanIsProhibited.No),

    //грубые причины отклонения для фраз и баннеров (требущие остановки баннера)
    STOP_BANNER_REASON_69(69, ModerateDiagsBadReason.Yes, ModerateDiagsUnbanIsProhibited.Yes),
    STOP_BANNER_REASON_128(128, ModerateDiagsBadReason.Yes, ModerateDiagsUnbanIsProhibited.Yes),
    STOP_BANNER_REASON_359(359, ModerateDiagsBadReason.Yes, ModerateDiagsUnbanIsProhibited.Yes),

    //приемлемые причины отклонения
    ADMISSIBLE_REASON_8(8, ModerateDiagsBadReason.No, ModerateDiagsUnbanIsProhibited.No),
    ADMISSIBLE_REASON_13(13, ModerateDiagsBadReason.No, ModerateDiagsUnbanIsProhibited.No),
    ADMISSIBLE_REASON_302(302, ModerateDiagsBadReason.No, ModerateDiagsUnbanIsProhibited.No);

    Integer diagId;
    ModerateDiagsBadReason badReason;
    ModerateDiagsUnbanIsProhibited unbanIsProhibited;

    ModerateTestDiags(Integer diagId, ModerateDiagsBadReason badReason, ModerateDiagsUnbanIsProhibited unbanIsProhibited) {
        this.diagId = diagId;
        this.badReason = badReason;
        this.unbanIsProhibited = unbanIsProhibited;
    }

    public Integer getDiagId() {
        return this.diagId;
    }

    public ModerateDiagsBadReason getBadReason() {
        return this.badReason;
    }
}
