package ru.yandex.autotests.directapi.darkside.model;

import java.util.Objects;

import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

/**
 * Параметры создания песочницы
 */
public class SandboxSettings {
    private final String clientType;
    private final String currency;
    private final boolean initTestData;
    private final boolean enableSharedAccount;

    public SandboxSettings(
            String clientType,
            String currency,
            boolean initTestData,
            boolean enableSharedAccount)
    {
        Objects.requireNonNull(clientType, "clientType");
        Objects.requireNonNull(currency, "currency");

        this.clientType = clientType;
        this.currency = currency;
        this.initTestData = initTestData;
        this.enableSharedAccount = enableSharedAccount;
    }

    @Override
    public String toString() {
        return ReflectionToStringBuilder.toString(this);
    }

    public String getClientType() {
        return clientType;
    }

    public String getCurrency() {
        return currency;
    }

    public boolean isInitTestData() {
        return initTestData;
    }

    public boolean isEnableSharedAccount() {
        return enableSharedAccount;
    }
}
