package ru.yandex.autotests.directapi.darkside.model;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by omaz on 06.05.14.
 */
public class ScriptParams {

    //стандартные параметры
    static final String ONCE = "--once";
    static final String SHARD_ID = "--shard-id";
    static final String CLEAR_ALL = "--clear-all";
    static final String SLEEP = "--sleep-time";

    // для скриптов транспорта
    static final String PAR_ID = "--par-id";
    static final String NO_SEND = "--no-send";
    static final String NO_RESYNC = "--no-resync";
    static final String MOBILE_CONTENT_ID = "--mobile-content-id";
    static final String LIMIT = "--limit";
    static final String FAKE_BS_URL = "--fake-bs-url";
    static final String FAKE_BS = "--fake-bs";
    static final String BSTORAGE_API_URL = "--bstorage_api_url";
    static final String FAKE_BS_URL_DATA = "--fake-bs-url-data";
    static final String FAKE_BS_URL_PRICES = "--fake-bs-url-prices";
    static final String NO_AUTO_BUGGY = "--no-auto-buggy";
    static final String EXT_TYPE = "--ext-type";
    static final String ADDITIONS_ITEM_ID = "--additions-item-id";
    static final String ID = "--id";
    //bsFullLBExportMaster.pl
    static final String MAX_QUEUE_SIZE = "--max-queue-size"; //максимально допустимое кол-во кампаний в очереди.
    static final String CHUNK_SIZE = "--chunk-size";         //размер пачки для добавления в очередь
    static final String LAST_CID = "--last-cid";             //cid, на котором закончили предыдущий чанк

    // для скрипта metrica_notify.pl
    static final String FAKE = "--fake";
    static final String LOGIN = "--login";
    static final String DEAD = "--dead";
    static final String ALIVE = "--alive";
    static final String DEAD_CHECK = "--dead-check";
    static final String DEAD_CHECK_FULL = "full";
    static final String DEAD_CHECK_PART = "partial";

    //для скрипта bsCheckAvailability.pl
    static final String DEAD_DOMAIN = "--dead-domain";
    static final String ALIVE_DOMAIN = "--alive-domain";
    static final String USAGE_PCT = "--usage-pct";
    static final String DEBUG = "--debug";

    static final String NO_JSON = "--no-json";
    static final String NO_SOAP = "--no-soap";
    static final String STOP = "--stop";
    static final String LOG_TO_DB = "--log-to-db";
    static final String CID = "--cid";
    static final String IMAGE_ID = "--image_id";

    static final String CLIENT_ID = "--clientid";
    //ppcProcessAutopayments
    static final String WALLET_CID = "--wallet-cid";
    static final String FORCE_CREATE_CAMP_BALANCE = "--force-create-camp-balance";
    static final String DONT_WAIT_NOTIFICATION = "--dont-wait-notification";
    //ppcFeedToBannerLandData
    static final String FEED_ID = "--feed-id";
    static final String BANNERLAND_URL = "--bannerland-url";

    static final String URL = "--url";

    static final String REPORT_ID = "--report-id";
    static final String QUERY_REPORT_TYPE = "--report-type";

    static final String CREATIVE_ID = "--creative_id";
    //ppcManageExperiments
    static final String EXPERIMENT_ID = "--experiment-id";

    static final String UNIQ = "--uniq";

    //ppcCampGetGoals
    static final String DAYS = "--days";
    static final String DATE_TO = "--date-to";
    static final String DATE_FROM = "--date-from";
    static final String FORCE = "--force";
    static final String SKIP_EXISTS = "--skip-exists";
    static final String NO_COUNT = "--no-count";

    //ppcFeedToBannerLand
    static final String MAX_FEED_SIZE = "--max-feed-size";


    List<String> params = new ArrayList<>();

    /*
        Общие методы для выставления параметров
     */
    public ScriptParams withCustomParam(String param, String value) {
        String paramWithValue = (value != null) ? param + "=" + value : param;
        params.add(paramWithValue);
        return this;
    }

    public ScriptParams withCustomParam(String param) {
        return withCustomParam(param, null);
    }


    /*
        Параметры для скриптов транспорта и не только
     */
    public ScriptParams once() {
        return withCustomParam(ONCE);
    }

    public ScriptParams withParId(String parId) {
        return withCustomParam(PAR_ID, parId);
    }

    public ScriptParams withSleep(Integer sleep) {
        return withCustomParam(SLEEP, String.valueOf(sleep));
    }


    public ScriptParams withShardId(Integer shardId) {
        return withCustomParam(SHARD_ID, String.valueOf(shardId));
    }

    public ScriptParams noResync() {
        return withCustomParam(NO_RESYNC);
    }

    public ScriptParams withClearAll() {
        return withCustomParam(CLEAR_ALL);
    }

    public ScriptParams fakeBs() {
        return withCustomParam(FAKE_BS);
    }

    public ScriptParams noSend() {
        return withCustomParam(NO_SEND);
    }

    public ScriptParams withChunkSize(Long chunkSize) {
        return withCustomParam(CHUNK_SIZE, chunkSize.toString());
    }

    public ScriptParams withMaxQueueSize(Long maxQueueSize) {
        return withCustomParam(MAX_QUEUE_SIZE, maxQueueSize.toString());
    }

    public ScriptParams withLastCid(Long lastCid) {
        return withCustomParam(LAST_CID, lastCid.toString());
    }


    /*
        Параметры для скрипта metrica_notify.pl
     */
    public ScriptParams fake() {
        return withCustomParam(FAKE);
    }

    public ScriptParams withLogin(String login) {
        return withCustomParam(LOGIN, login);
    }

    public ScriptParams withDead(String domain) {
        return withCustomParam(DEAD, domain);
    }

    public ScriptParams withAlive(String domain) {
        return withCustomParam(ALIVE, domain);
    }

    public ScriptParams withFullDeadCheck() {
        return withCustomParam(DEAD_CHECK, DEAD_CHECK_FULL);
    }

    public ScriptParams withPartialDeadCheck() {
        return withCustomParam(DEAD_CHECK, DEAD_CHECK_PART);
    }


    /* Параметры для скрипта bsCheckAvailability.pl */

    public ScriptParams withDeadDamains(String... domains) {
        for (String domain : domains) {
            withCustomParam(DEAD_DOMAIN, String.valueOf(domain));
        }
        return this;
    }

    public ScriptParams withAliveDamains(String... domains) {
        for (String domain : domains) {
            withCustomParam(ALIVE_DOMAIN, String.valueOf(domain));
        }
        return this;
    }

    public ScriptParams withDebug() {
        withCustomParam(DEBUG);
        return this;
    }

    public ScriptParams withUniq(Integer uniq) {
        return withCustomParam(UNIQ, String.valueOf(uniq));
    }

    public ScriptParams noJson() {
        return withCustomParam(NO_JSON);
    }

    public ScriptParams noSoap() {
        return withCustomParam(NO_SOAP);
    }

    public ScriptParams stop() {
        return withCustomParam(STOP);
    }

    public ScriptParams writeLogToDb() {
        return withCustomParam(LOG_TO_DB);
    }

    public ScriptParams withDontWaitNotification() {
        return withCustomParam(DONT_WAIT_NOTIFICATION);
    }

    @Deprecated
    public ScriptParams withCids(int... cids) {
        for (int cid : cids) {
            withCustomParam(CID, String.valueOf(cid));
        }
        return this;
    }

    public ScriptParams withCids(Long... cids) {
        for (Long cid : cids) {
            withCustomParam(CID, String.valueOf(cid));
        }
        return this;
    }

    public ScriptParams withImageIds(Long... imageIds) {
        for (Long imageId : imageIds) {
            withCustomParam(IMAGE_ID, String.valueOf(imageId));
        }
        return this;
    }

    public ScriptParams withClientIds(String... clientIds) {
        if (clientIds != null) {
            for (String clientId : clientIds) {
                withCustomParam(CLIENT_ID, clientId);
            }
        }
        return this;
    }

    public ScriptParams withFeedIds(Long... feedIds) {
        if (feedIds != null) {
            for (Long feedId : feedIds) {
                withCustomParam(FEED_ID, Long.toString(feedId));
            }
        }
        return this;
    }

    public ScriptParams withBannerLandUrl(String url) {
        if (url != null) {
            withCustomParam(BANNERLAND_URL, url);
        }
        return this;
    }


    public ScriptParams withMobileContentIds(Long... mobileContentIds) {
        for (Long mobileContentId : mobileContentIds) {
            withCustomParam(MOBILE_CONTENT_ID, Long.toString(mobileContentId));
        }
        return this;
    }

    public ScriptParams withLimit(int limit) {
        withCustomParam(LIMIT, Integer.toString(limit));
        return this;
    }

    public ScriptParams withFakeBSUrl(String fakeBSUrl) {
        if (fakeBSUrl != null) {
            withCustomParam(FAKE_BS_URL, fakeBSUrl);
        }
        return this;
    }

    public ScriptParams withUrl(String url) {
        withCustomParam(URL, url);
        return this;
    }

    public ScriptParams withReportId(int reportId) {
        withCustomParam(REPORT_ID, Integer.toString(reportId));
        return this;
    }

    public ScriptParams withCreativeIds(Long... creativeIds) {
        for (Long creativeId : creativeIds) {
            withCustomParam(CREATIVE_ID, creativeId.toString());
        }
        return this;
    }

    public ScriptParams withBstorageApiUrl(String bsApiUrl) {
        withCustomParam(BSTORAGE_API_URL, bsApiUrl);
        return this;
    }

    public ScriptParams withWalletCid(Long walletCid) {
        withCustomParam(WALLET_CID, Long.toString(walletCid));
        return this;
    }

    @Override
    public String toString() {
        return String.join(" ", params);
    }

    public ScriptParams withReportType(String reportType) {
        withCustomParam(QUERY_REPORT_TYPE, reportType);
        return this;
    }

    public ScriptParams withForceCreateCampBalance() {
        withCustomParam(FORCE_CREATE_CAMP_BALANCE);
        return this;
    }

    public ScriptParams withExtType(ExtType extType) {
        withCustomParam(EXT_TYPE, extType.toString());
        return this;
    }

    public ScriptParams withExperimentId(Long experimentId) {
        withCustomParam(EXPERIMENT_ID, String.valueOf(experimentId));
        return this;
    }

    public ScriptParams withAdditionsItemId(Long id) {
        withCustomParam(ADDITIONS_ITEM_ID, String.valueOf(id));
        return this;
    }

    public ScriptParams withIds(Long... ids) {
        for (Long id : ids) {
            withCustomParam(ID, Long.toString(id));
        }
        return this;
    }

    public ScriptParams force() {
        return withCustomParam(FORCE);
    }

    public ScriptParams noCount() {
        return withCustomParam(NO_COUNT);
    }

    public ScriptParams skipExists() {
        return withCustomParam(SKIP_EXISTS);
    }

    public ScriptParams withDays(int days) {
        return withCustomParam(DAYS, String.valueOf(days));
    }

    public ScriptParams withDateFrom(String dateFrom) {
        return withCustomParam(DATE_FROM, dateFrom);
    }

    public ScriptParams withDateTo(String dateTo) {
        return withCustomParam(DATE_TO, dateTo);
    }

    public ScriptParams withMaxFeedSize(int maxFeedSize) {
        withCustomParam(MAX_FEED_SIZE, String.valueOf(maxFeedSize));
        return this;
    }
}
