package ru.yandex.autotests.directapi.darkside.model;

/**
 * Created by omaz on 20.05.14.
 * Описывает скрипты, которые можно запускать из тестов и их дефолтные параметры
 */
public enum Scripts {
    //описание скриптов:
    //https://wiki.yandex-team.ru/testirovanie/functesting/direkt/automatization/intapi/testirovanieskriptovidostupvbazu/SkriptyDirekta
    API_REPORTS_BUILDER("apiReportsBuilder.pl"),
    BS_EXPORT_MASTER("bsExportMaster.pl",
            new ScriptParams()
                    .once()),
    BS_CLIENT_DATA("bsClientData.pl",
            new ScriptParams()
                    .once()
                    .withParId("std:1")),
    BS_CHECK_URL_AVAILABILITY("bsCheckUrlAvailability.pl",
            new ScriptParams()
                    .withShardId(1)),
    PPC_REDIRECT_CHECK("ppcRedirectCheck.pl",
            new ScriptParams()
                    .withShardId(1)),
    PPC_ARCHIVE_OLD_BANNERS("ppcArchiveOldBanners.pl"),
    PPC_CAMP_AUTOPRICE("ppcCampAutoPrice.pl",
            new ScriptParams()
                    .withParId("easy:1")
                    .withShardId(1)),
    PPC_PUSH_NOTIFICATIONS_QUEUE("ppcPushNotificationsQueue.pl",
            new ScriptParams()
                    .withShardId(1)),
    ANTISPAM_CREATE_REPORT("antispam_create_report.pl"),
    PPC_FETCH_AGENCY_COUNTRY_CURRENCY("ppcFetchAgencyCountryCurrency.pl"),
    PPC_CAMP_QUEUE("ppcCampQueue.pl",
            new ScriptParams()
                    .once()
                    .withShardId(1)),
    FILL_CURRENCY_RATES("maintenance/fill_currency_rates.pl"),
    BALANCE_GET_CLIENT_NDS_DISCOUNT_SHEDULE("balanceGetClientNDSDiscountSchedule.pl",
            new ScriptParams()),
    PPC_FORCE_CURRENCY_CONVERT("ppcForceCurrencyConvert.pl",
            new ScriptParams()
                    .withShardId(1)),
    PPC_FORCE_CURRENCY_CONVERT_NOTIFY("ppcForceCurrencyConvertNotify.pl",
            new ScriptParams()
                    .withShardId(1)),
    PPC_PREPARE_DYNAMIC_ADGROUPS_FOR_EXPORT("ppcPrepareDynamicAdgroupsForExport.pl",
            new ScriptParams()),
    PPC_FETCH_CLIENT_MULTICURRENCY_TEASER_DATA("ppcFetchClientMulticurrencyTeaserData.pl",
            new ScriptParams()),
    PPC_RETARGETING_CHECK_GOALS("ppcRetargetingCheckGoals.pl", new ScriptParams()),
    PPC_UPDATE_STORE_CONTENT("ppcUpdateStoreContent.pl", new ScriptParams()),
    PPC_SEARCH_QUERY_STATUS("ppcSearchQueryStatus.pl"),
    PPC_FEED_TO_BANNER_LAND("ppcFeedToBannerLand.pl",
            new ScriptParams()
                    .once()
                    .withShardId(1)),
    PPC_PROCESS_IMAGE_QUEUE("ppcProcessImageQueue.pl",
            new ScriptParams()),
    PPC_SET_AUTO_RESOURCES("ppcSetAutoResources.pl",
            new ScriptParams()),
    PPC_PROCESS_AUTO_PAYMENTS("ppcProcessAutoPayments.pl",
            new ScriptParams()),
    PPC_COPY_SUBCLIENTS_FORCE_CURRENCY("ppcCopySubclientsForceCurrency.pl",
            new ScriptParams()),
    PPC_FEEDS_REJECTED_OFFERS("ppcFeedsRejectedOffers.pl",
            new ScriptParams()),
    PPC_MANAGE_EXPERIMENTS("ppcManageExperiments.pl",
            new ScriptParams()),
    PPC_CAMP_GET_GOALS("ppcCampGetGoals.pl",
            new ScriptParams()),
    PPC_CLEAR_OLD_UNPAID_CAMPAIGNS("ppcClearOldUnpaidCampaigns.pl",
            new ScriptParams()),
    UPDATE_PERF_COUNTERS("conv/update_perf_counters.pl");

    String scriptName;
    ScriptParams defaultParams;

    Scripts(String scriptName) {
        this.scriptName = scriptName;
    }

    Scripts(String scriptName, ScriptParams params) {
        this.scriptName = scriptName;
        this.defaultParams = params;
    }

    public String getScriptName() {
        return scriptName;
    }

    public ScriptParams getDefaultParams() {
        return defaultParams;
    }
}
