package ru.yandex.autotests.directapi.darkside.model;

/**
 * Created by buhter on 18/08/16.
 */
public enum TimeZoneCountryEnum {

    AFRICA_ABIDJAN("Africa/Abidjan", (short) 25, (short) 20733, "Кот-д’Ивуар"),
    AFRICA_ACCRA("Africa/Accra", (short) 210, (short) 20802, "Гана"),
    AFRICA_ADDIS_ABABA("Africa/Addis_Ababa", (short) 104, (short) 20768, "Эфиопия"),
    AFRICA_ALGIERS("Africa/Algiers", (short) 22, (short) 20826, "Алжир"),
    AFRICA_ASMERA("Africa/Asmera", (short) 129, (short) 20989, "Эритрея"),
    AFRICA_BAMAKO_MALI("Africa/Bamako", (short) 191, (short) 21004, "Мали"),
    AFRICA_BAMAKO_BURKINA_FASO("Africa/Bamako", (short) 200, (short) 21165, "Буркина-Фасо"),
    AFRICA_BANGUI("Africa/Bangui", (short) 73, (short) 21007, "Центрально-Африканская Республика"),
    AFRICA_BANJUL("Africa/Banjul", (short) 205, (short) 21010, "Гамбия"),
    AFRICA_BISSAU("Africa/Bissau", (short) 11, (short) 21143, "Гвинея-Бисау"),
    AFRICA_BRAZZAVILLE("Africa/Brazzaville", (short) 186, (short) 21198, "Республика Конго"),
    AFRICA_BUJUMBURA("Africa/Bujumbura", (short) 109, (short) 21214, "Бурунди"),
    AFRICA_CAIRO("Africa/Cairo", (short) 16, (short) 1056, "Египет"),
    AFRICA_CASABLANCA("Africa/Casablanca", (short) 158, (short) 10020, "Марокко"),
    AFRICA_CONAKRY("Africa/Conakry", (short) 48, (short) 20818, "Гвинея"),
    AFRICA_DAKAR("Africa/Dakar", (short) 123, (short) 21441, "Сенегал"),
    AFRICA_DAR_ES_SALAAM("Africa/Dar_es_Salaam", (short) 125, (short) 21208, "Танзания"),
    AFRICA_DJIBOUTI("Africa/Djibouti", (short) 117, (short) 21475, "Джибути"),
    AFRICA_DOUALA("Africa/Douala", (short) 45, (short) 20736, "Камерун"),
    AFRICA_EL_AAIUN("Africa/El_Aaiun", (short) 167, (short) 20789, "Сахарская Арабская Демократическая Республика"),
    AFRICA_FREETOWN("Africa/Freetown", (short) 67, (short) 21219, "Сьерра-Леоне"),
    AFRICA_GABORONE("Africa/Gaborone", (short) 217, (short) 21239, "Ботсвана"),
    AFRICA_HARARE("Africa/Harare", (short) 176, (short) 20954, "Зимбабве"),
    AFRICA_JOHANNESBURG("Africa/Johannesburg", (short) 82, (short) 10021, "ЮАР"),
    AFRICA_KAMPALA("Africa/Kampala", (short) 69, (short) 21230, "Уганда"),
    AFRICA_KHARTOUM_SUDAN("Africa/Khartoum", (short) 107, (short) 20957, "Судан"),
    AFRICA_KHARTOUM_SOUTH_SUDAN("Africa/Khartoum", (short) 264, (short) 108137, "ЮжныйСудан"),
    AFRICA_KIGALI_RHUANDA("Africa/Kigali", (short) 201, (short) 21371, "Руанда"),
    AFRICA_KIGALI_CONGO("Africa/Kigali", (short) 250, (short) 20762, "Демократическая Республика Конго"),
    AFRICA_KINSHASA_ANGOLA("Africa/Kinshasa", (short) 165, (short) 21182, "Ангола"),
    AFRICA_KINSHASA_CONGO("Africa/Kinshasa", (short) 37, (short) 20762, "Демократическая Республика Конго"),
    AFRICA_LAGOS("Africa/Lagos", (short) 66, (short) 20741, "Нигерия"),
    AFRICA_LIBREVILLE("Africa/Libreville", (short) 160, (short) 21137, "Габон"),
    AFRICA_LOME("Africa/Lome", (short) 5, (short) 21171, "Того"),
    AFRICA_LUSAKA_ZAMBIA("Africa/Lusaka", (short) 164, (short) 21196, "Замбия"),
    AFRICA_LUSAKA_MALAVI("Africa/Lusaka", (short) 18, (short) 21151, "Малави"),
    AFRICA_MALABO("Africa/Malabo", (short) 159, (short) 21045, "Экваториальная Гвинея"),
    AFRICA_MAPUTO("Africa/Maputo", (short) 155, (short) 21235, "Мозамбик"),
    AFRICA_MASERU("Africa/Maseru", (short) 8, (short) 21261, "Лесото"),
    AFRICA_MBABANE("Africa/Mbabane", (short) 97, (short) 21251, "Свазиленд"),
    AFRICA_MOGADISHU("Africa/Mogadishu", (short) 183, (short) 21227, "Сомали"),
    AFRICA_MONROVIA("Africa/Monrovia", (short) 86, (short) 21278, "Либерия"),
    AFRICA_NAIROBI("Africa/Nairobi", (short) 1, (short) 21223, "Кения"),
    AFRICA_NDJAMENA("Africa/Ndjamena", (short) 55, (short) 21331, "Чад"),
    AFRICA_NIAMEY("Africa/Niamey", (short) 199, (short) 21339, "Нигер"),
    AFRICA_NOUAKCHOTT("Africa/Nouakchott", (short) 188, (short) 21349, "Мавритания"),
    AFRICA_PORTO_NOVO("Africa/Porto-Novo", (short) 146, (short) 20869, "Бенин"),
    AFRICA_SAO_TOME("Africa/Sao_Tome", (short) 64, (short) 21199, "Сан-ТомеиПринсипи"),
    AFRICA_TRIPOLI("Africa/Tripoli", (short) 68, (short) 10023, "Ливия"),
    AFRICA_TUNIS("Africa/Tunis", (short) 227, (short) 10024, "Тунис"),
    AFRICA_WINDHOEK("Africa/Windhoek", (short) 32, (short) 21217, "Намибия"),
    AMERICA_ANGUILLA("America/Anguilla", (short) 211, (short) 21534, "Ангилья"),
    AMERICA_ANTIGUA("America/Antigua", (short) 10, (short) 20856, "АнтигуаиБарбуда"),
    AMERICA_ARGENTINA_BUENOS_AIRES("America/Argentina/Buenos_Aires", (short) 184, (short) 93, "Аргентина"),
    AMERICA_ARUBA("America/Aruba", (short) 115, (short) 21536, "Аруба"),
    AMERICA_ASUNCION("America/Asuncion", (short) 185, (short) 20992, "Парагвай"),
    AMERICA_BARBADOS("America/Barbados", (short) 173, (short) 21019, "Барбадос"),
    AMERICA_BELIZE("America/Belize", (short) 53, (short) 21544, "Белиз"),
    AMERICA_BOGOTA("America/Bogota", (short) 212, (short) 21191, "Колумбия"),
    AMERICA_CAYENNE_GUIANNA("America/Cayenne", (short) 106, (short) 21451, "Французская Гвиана"),
    AMERICA_CAYENNE_SURINAM("America/Cayenne", (short) 207, (short) 21344, "Суринам"),
    AMERICA_CAYMAN("America/Cayman", (short) 216, (short) 21570, "Каймановы острова"),
    AMERICA_CHIHUAHUA("America/Chihuahua", (short) 128, (short) 20271, "Мексика"),
    AMERICA_COSTA_RICA("America/Costa_Rica", (short) 24, (short) 21131, "Коста-Рика"),
    AMERICA_CURACAO_SINT_MARTIN("America/Curacao", (short) 268, (short) 109724, "Синт-Мартен"),
    AMERICA_CURACAO_CURACAO("America/Curacao", (short) 77, (short) 21538, "Кюрасао"),
    AMERICA_DENVER("America/Denver", (short) 41, (short) 84, "США"),
    AMERICA_DOMINICA_MARTINIKA("America/Dominica", (short) 143, (short) 101521, "Мартиника"),
    AMERICA_DOMINICA_SANTA_LICIA("America/Dominica", (short) 153, (short) 21395, "Сент-Люсия"),
    AMERICA_DOMINICA("America/Dominica", (short) 58, (short) 20746, "Доминика"),
    AMERICA_GODTHAB("America/Godthab", (short) 76, (short) 21567, "Гренландия"),
    AMERICA_GRAND_TURK("America/Grand_Turk", (short) 34, (short) 21595, "Тёркси Кайкос"),
    AMERICA_GRENADA("America/Grenada", (short) 90, (short) 21426, "Гренада"),
    AMERICA_GUATEMALA_GUATEMALA("America/Guatemala", (short) 150, (short) 20968, "Гватемала"),
    AMERICA_GUATEMALA_SAALVADOR("America/Guatemala", (short) 240, (short) 20769, "Сальвадор"),
    AMERICA_GUYANA("America/Guyana", (short) 105, (short) 21477, "Гайана"),
    AMERICA_HALIFAX("America/Halifax", (short) 276, (short) 95, "Канада"),
    AMERICA_HAVANA("America/Havana", (short) 85, (short) 10017, "Куба"),
    AMERICA_HERMOSILLO("America/Hermosillo", (short) 253, (short) 20271, "Мексика"),
    AMERICA_JAMAICA("America/Jamaica", (short) 17, (short) 10013, "Ямайка"),
    AMERICA_JUNEAU("America/Juneau", (short) 44, (short) 84, "США"),
    AMERICA_KENTUCKY_MONTICELLO("America/Kentucky/Monticello", (short) 761, (short) 84, "США"),
    AMERICA_LA_PAZ("America/La_Paz", (short) 102, (short) 10015, "Боливия"),
    AMERICA_LIMA_ECUADOR("America/Lima", (short) 100, (short) 20785, "Эквадор"),
    AMERICA_LIMA_PANAMA("America/Lima", (short) 47, (short) 21299, "Панама"),
    AMERICA_LIMA_PERU("America/Lima", (short) 74, (short) 21156, "Перу"),
    AMERICA_LOS_ANGELES("America/Los_Angeles", (short) 39, (short) 84, "США"),
    AMERICA_LOUISVILLE("America/Louisville", (short) 38, (short) 84, "США"),
    AMERICA_MACEIO("America/Maceio", (short) 277, (short) 94, "Бразилия"),
    AMERICA_MANAGUA("America/Managua", (short) 179, (short) 21231, "Никарагуа"),
    AMERICA_MANAUS("America/Manaus", (short) 80, (short) 94, "Бразилия"),
    AMERICA_MEXICO_CITY("America/Mexico_City", (short) 127, (short) 20271, "Мексика"),
    AMERICA_MIQUELON("America/Miquelon", (short) 283, (short) 95, "Канада"),
    AMERICA_MONTEVIDEO("America/Montevideo", (short) 126, (short) 21289, "Уругвай"),
    AMERICA_MONTSERRAT("America/Montserrat", (short) 198, (short) 37176, "Монтсеррат"),
    AMERICA_NASSAU("America/Nassau", (short) 241, (short) 21325, "Багамскиеострова"),
    AMERICA_NORTH_DAKOTA_CENTER("America/North_Dakota/Center", (short) 42, (short) 84, "США"),
    AMERICA_PORT_AU_PRINCE("America/Port-au-Prince", (short) 29, (short) 21321, "Гаити"),
    AMERICA_PORT_OF_SPAIN("America/Port_of_Spain", (short) 182, (short) 21187, "Тринидад и Тобаго"),
    AMERICA_PUERTO_RICO("America/Puerto_Rico", (short) 46, (short) 20764, "Пуэрто-Рико"),
    AMERICA_SANTIAGO_FOLKLAND("America/Santiago", (short) 108, (short) 101519, "Фолклендские острова"),
    AMERICA_SANTIAGO_CHILI("America/Santiago", (short) 237, (short) 20862, "Чили"),
    AMERICA_SANTO_DOMINGO("America/Santo_Domingo", (short) 88, (short) 20917, "Доминиканская Республика"),
    AMERICA_SAO_PAULO("America/Sao_Paulo", (short) 79, (short) 94, "Бразилия"),
    AMERICA_ST_KITTS("America/St_Kitts", (short) 101, (short) 21042, "Сент-Китси Невис"),
    AMERICA_ST_THOMAS("America/St_Thomas", (short) 247, (short) 21553, "Американские Виргинские острова"),
    AMERICA_ST_VINCENT("America/St_Vincent", (short) 169, (short) 20754, "Сент-Винсенти Гренадины"),
    AMERICA_SWIFT_CURRENT("America/Swift_Current", (short) 282, (short) 95, "Канада"),
    AMERICA_TEGUCIGALPA("America/Tegucigalpa", (short) 226, (short) 21175, "Гондурас"),
    AMERICA_TIJUANA("America/Tijuana", (short) 280, (short) 20271, "Мексика"),
    AMERICA_TORONTO("America/Toronto", (short) 218, (short) 95, "Канада"),
    AMERICA_TORTOLA("America/Tortola", (short) 156, (short) 21559, "Британские Виргинские острова"),
    AMERICA_VANCOUVER("America/Vancouver", (short) 222, (short) 95, "Канада"),
    AMERICA_WINNIPEG("America/Winnipeg", (short) 221, (short) 95, "Канада"),
    AMERICA_YELLOWKNIFE("America/Yellowknife", (short) 219, (short) 95, "Канада"),
    ASIA_ADEN("Asia/Aden", (short) 215, (short) 21551, "Йемен"),
    ASIA_ALMATY("Asia/Almaty", (short) 119, (short) 159, "Казахстан"),
    ASIA_AMMAN("Asia/Amman", (short) 232, (short) 10535, "Иордания"),
    ASIA_AQTOBE("Asia/Aqtobe", (short) 120, (short) 159, "Казахстан"),
    ASIA_ASHGABAT("Asia/Ashgabat", (short) 3, (short) 170, "Туркмения"),
    ASIA_BAGHDAD("Asia/Baghdad", (short) 111, (short) 20572, "Ирак"),
    ASIA_BAHRAIN_BAHRAIN("Asia/Bahrain", (short) 181, (short) 10532, "Бахрейн"),
    ASIA_BAHRAIN_QATAR("Asia/Bahrain", (short) 229, (short) 21486, "Катар"),
    ASIA_BAKU("Asia/Baku", (short) 98, (short) 167, "Азербайджан"),
    ASIA_BANGKOK("Asia/Bangkok", (short) 148, (short) 995, "Таиланд"),
    ASIA_BEIRUT("Asia/Beirut", (short) 116, (short) 10538, "Ливан"),
    ASIA_BISHKEK("Asia/Bishkek", (short) 4, (short) 207, "Киргизия"),
    ASIA_BRUNEI("Asia/Brunei", (short) 51, (short) 20274, "Бруней"),
    ASIA_DAMASCUS("Asia/Damascus", (short) 27, (short) 10542, "Сирия"),
    ASIA_DHAKA("Asia/Dhaka", (short) 36, (short) 10091, "Бангладеш"),
    ASIA_DILI("Asia/Dili", (short) 65, (short) 21562, "Восточный Тимор"),
    ASIA_DUBAI("Asia/Dubai", (short) 203, (short) 210, "Объединённые Арабские Эмираты"),
    ASIA_DUSHANBE("Asia/Dushanbe", (short) 147, (short) 209, "Таджикистан"),
    ASIA_GAZA("Asia/Gaza", (short) 33, (short) 98552, "Палестина"),
    ASIA_HOVD("Asia/Hovd", (short) 234, (short) 10099, "Монголия"),
    ASIA_IRKUTSK("Asia/Irkutsk", (short) 135, (short) 225, "Россия"),
    ASIA_JAKARTA_INONESIA("Asia/Jakarta", (short) 113, (short) 10095, "Индонезия"),
    ASIA_JAKARTA_AUSTRALIA("Asia/Jakarta", (short) 93, (short) 211, "Австралия"),
    ASIA_JAYAPURA("Asia/Jayapura", (short) 114, (short) 10095, "Индонезия"),
    ASIA_JERUSALEM("Asia/Jerusalem", (short) 6, (short) 181, "Израиль"),
    ASIA_KAMCHATKA("Asia/Kamchatka", (short) 764, (short) 225, "Россия"),
    ASIA_KARACHI("Asia/Karachi", (short) 238, (short) 10102, "Пакистан"),
    ASIA_KRASNOYARSK("Asia/Krasnoyarsk", (short) 134, (short) 225, "Россия"),
    ASIA_KUALA_LUMPUR("Asia/Kuala_Lumpur", (short) 124, (short) 10097, "Малайзия"),
    ASIA_KUWAIT("Asia/Kuwait", (short) 141, (short) 10537, "Кувейт"),
    ASIA_MAKASSAR("Asia/Makassar", (short) 279, (short) 10095, "Индонезия"),
    ASIA_MANILA("Asia/Manila", (short) 26, (short) 10108, "Филиппины"),
    ASIA_MUSCAT("Asia/Muscat", (short) 30, (short) 21586, "Оман"),
    ASIA_NICOSIA("Asia/Nicosia", (short) 83, (short) 20574, "Кипр"),
    ASIA_OMSK("Asia/Omsk", (short) 270, (short) 225, "Россия"),
    ASIA_PHNOM_PENH("Asia/Phnom_Penh", (short) 145, (short) 20975, "Камбоджа"),
    ASIA_PYONGYANG("Asia/Pyongyang", (short) 209, (short) 10104, "Северная Корея"),
    ASIA_RIYADH("Asia/Riyadh", (short) 72, (short) 10540, "Саудовская Аравия"),
    ASIA_SEOUL("Asia/Seoul", (short) 75, (short) 135, "Южная Корея"),
    ASIA_SHANGHAI_CHINA("Asia/Shanghai", (short) 189, (short) 134, "Китай"),
    ASIA_SHANGHAI_THAI("Asia/Shanghai", (short) 763, (short) 29385, "Тайвань"),
    ASIA_SINGAPORE_INDONESIA("Asia/Singapore", (short) 112, (short) 10095, "Индонезия"),
    ASIA_SINGAPORE_SINGAPORE("Asia/Singapore", (short) 62, (short) 10105, "Сингапур"),
    ASIA_SREDNEKOLYMSK("Asia/Srednekolymsk", (short) 766, (short) 225, "Россия"),
    ASIA_TASHKENT("Asia/Tashkent", (short) 178, (short) 171, "Узбекистан"),
    ASIA_TBILISI("Asia/Tbilisi", (short) 121, (short) 169, "Грузия"),
    ASIA_THIMPHU("Asia/Thimphu", (short) 60, (short) 21550, "Бутан"),
    ASIA_TOKYO("Asia/Tokyo", (short) 59, (short) 137, "Япония"),
    ASIA_ULAANBAATAR("Asia/Ulaanbaatar", (short) 233, (short) 10099, "Монголия"),
    ASIA_URUMQI("Asia/Urumqi", (short) 767, (short) 134, "Китай"),
    ASIA_VIENTIANE_LAOS("Asia/Vientiane", (short) 193, (short) 20972, "Лаос"),
    ASIA_VIENTIANE_VIENTIANE("Asia/Vientiane", (short) 21, (short) 10093, "Вьетнам"),
    ASIA_VLADIVOSTOK("Asia/Vladivostok", (short) 138, (short) 225, "Россия"),
    ASIA_YAKUTSK("Asia/Yakutsk", (short) 137, (short) 225, "Россия"),
    ASIA_YEKATERINBURG("Asia/Yekaterinburg", (short) 133, (short) 225, "Россия"),
    ASIA_YEREVAN("Asia/Yerevan", (short) 13, (short) 168, "Армения"),
    ATLANTIC_AZORES("Atlantic/Azores", (short) 152, (short) 10074, "Португалия"),
    ATLANTIC_BERMUDA("Atlantic/Bermuda", (short) 228, (short) 21546, "Бермудские Острова"),
    ATLANTIC_CANARY("Atlantic/Canary", (short) 163, (short) 204, "Испания"),
    ATLANTIC_CAPE_VERDE("Atlantic/Cape_Verde", (short) 99, (short) 21326, "Кабо-Верде"),
    ATLANTIC_FAEROE("Atlantic/Faeroe", (short) 224, (short) 203, "Дания"),
    ATLANTIC_REYKJAVIK("Atlantic/Reykjavik", (short) 12, (short) 10064, "Исландия"),
    AUSTRALIA_BRISBANE("Australia/Brisbane", (short) 278, (short) 211, "Австралия"),
    AUSTRALIA_MELBOURNE("Australia/Melbourne", (short) 262, (short) 98539, "Норфолк"),
    AUSTRALIA_PERTH("Australia/Perth", (short) 94, (short) 211, "Австралия"),
    AUSTRALIA_SYDNEY("Australia/Sydney", (short) 91, (short) 211, "Австралия"),
    EUROPE_AMSTERDAM("Europe/Amsterdam", (short) 174, (short) 118, "Нидерланды"),
    EUROPE_ANDORRA("Europe/Andorra", (short) 54, (short) 10088, "Андорра"),
    EUROPE_ATHENS("Europe/Athens", (short) 195, (short) 246, "Греция"),
    EUROPE_BELGRADE_SERBIA("Europe/Belgrade", (short) 57, (short) 180, "Сербия"),
    EUROPE_BELGRADE_MONTENEGRO("Europe/Belgrade", (short) 9, (short) 21610, "Черногория"),
    EUROPE_BERLIN("Europe/Berlin", (short) 56, (short) 96, "Германия"),
    EUROPE_BRATISLAVA("Europe/Bratislava", (short) 87, (short) 121, "Словакия"),
    EUROPE_BRUSSELS("Europe/Brussels", (short) 244, (short) 114, "Бельгия"),
    EUROPE_BUCHAREST("Europe/Bucharest", (short) 206, (short) 10077, "Румыния"),
    EUROPE_BUDAPEST("Europe/Budapest", (short) 197, (short) 116, "Венгрия"),
    EUROPE_COPENHAGEN("Europe/Copenhagen", (short) 225, (short) 203, "Дания"),
    EUROPE_DUBLIN("Europe/Dublin", (short) 168, (short) 10063, "Ирландия"),
    EUROPE_GIBRALTAR("Europe/Gibraltar", (short) 175, (short) 10089, "Гибралтар"),
    EUROPE_HELSINKI("Europe/Helsinki", (short) 122, (short) 123, "Финляндия"),
    EUROPE_ISTANBUL("Europe/Istanbul", (short) 180, (short) 983, "Турция"),
    EUROPE_KALININGRAD("Europe/Kaliningrad", (short) 131, (short) 225, "Россия"),
    EUROPE_KIEV_MOLDOVA("Europe/Kiev", (short) 243, (short) 208, "Молдова"),
    EUROPE_KIEV_UKRAINE("Europe/Kiev", (short) 61, (short) 187, "Украина"),
    EUROPE_LISBON("Europe/Lisbon", (short) 151, (short) 10074, "Португалия"),
    EUROPE_LJUBLJANA("Europe/Ljubljana", (short) 236, (short) 122, "Словения"),
    EUROPE_LONDON("Europe/London", (short) 170, (short) 102, "Великобритания"),
    EUROPE_LUXEMBOURG("Europe/Luxembourg", (short) 223, (short) 21203, "Люксембург"),
    EUROPE_MADRID("Europe/Madrid", (short) 162, (short) 204, "Испания"),
    EUROPE_MALTA("Europe/Malta", (short) 50, (short) 10069, "Мальта"),
    EUROPE_MINSK("Europe/Minsk", (short) 149, (short) 149, "Беларусь"),
    EUROPE_MONACO("Europe/Monaco", (short) 187, (short) 10070, "Монако"),
    EUROPE_MOSCOW_RUSSIA("Europe/Moscow", (short) 130, (short) 225, "Россия"),
    EUROPE_MOSCOW_ABHASIA("Europe/Moscow", (short) 166, (short) 29386, "Абхазия"),
    EUROPE_MOSCOW_POLAND("Europe/Moscow", (short) 275, (short) 120, "Польша"),
    EUROPE_MOSCOW_OSETIA("Europe/Moscow", (short) 81, (short) 29387, "Южная Осетия"),
    EUROPE_OSLO("Europe/Oslo", (short) 23, (short) 119, "Норвегия"),
    EUROPE_PARIS("Europe/Paris", (short) 15, (short) 124, "Франция"),
    EUROPE_PRAGUE("Europe/Prague", (short) 172, (short) 125, "Чехия"),
    EUROPE_RIGA("Europe/Riga", (short) 110, (short) 206, "Латвия"),
    EUROPE_ROME_PORTO("Europe/Rome", (short) 254, (short) 10074, "Португалия"),
    EUROPE_ROME_ITALY("Europe/Rome", (short) 28, (short) 205, "Италия"),
    EUROPE_SAMARA("Europe/Samara", (short) 765, (short) 225, "Россия"),
    EUROPE_SAN_MARINO("Europe/San_Marino", (short) 142, (short) 20790, "Сан-Марино"),
    EUROPE_SARAJEVO("Europe/Sarajevo", (short) 239, (short) 10057, "Боснияи Герцеговина"),
    EUROPE_SKOPJE("Europe/Skopje", (short) 202, (short) 10068, "Македония"),
    EUROPE_SOFIA("Europe/Sofia", (short) 103, (short) 115, "Болгария"),
    EUROPE_STOCKHOLM("Europe/Stockholm", (short) 192, (short) 127, "Швеция"),
    EUROPE_TALLINN("Europe/Tallinn", (short) 19, (short) 179, "Эстония"),
    EUROPE_TIRANE("Europe/Tirane", (short) 31, (short) 10054, "Албания"),
    EUROPE_VADUZ("Europe/Vaduz", (short) 84, (short) 10067, "Лихтенштейн"),
    EUROPE_VATICAN("Europe/Vatican", (short) 78, (short) 21359, "Ватикан"),
    EUROPE_VIENNA("Europe/Vienna", (short) 157, (short) 113, "Австрия"),
    EUROPE_VILNIUS("Europe/Vilnius", (short) 71, (short) 117, "Литва"),
    EUROPE_WARSAW("Europe/Warsaw", (short) 208, (short) 120, "Польша"),
    EUROPE_ZAGREB("Europe/Zagreb", (short) 2, (short) 10083, "Хорватия"),
    EUROPE_ZURICH("Europe/Zurich", (short) 49, (short) 126, "Швейцария"),
    INDIAN_ANTANANARIVO("Indian/Antananarivo", (short) 35, (short) 20854, "Мадагаскар"),
    INDIAN_COMORO("Indian/Comoro", (short) 214, (short) 21297, "Коморские острова"),
    INDIAN_MALDIVES("Indian/Maldives", (short) 20, (short) 10098, "Мальдивы"),
    INDIAN_MAURITIUS_MAURITIUS("Indian/Mauritius", (short) 235, (short) 21241, "Маврикий"),
    INDIAN_MAURITIUS_SEISHELL("Indian/Mauritius", (short) 242, (short) 10022, "Сейшельские острова"),
    PACIFIC_APIA("Pacific/Apia", (short) 7, (short) 20860, "Самоа"),
    PACIFIC_AUCKLAND("Pacific/Auckland", (short) 154, (short) 139, "Новая Зеландия"),
    PACIFIC_EASTER("Pacific/Easter", (short) 281, (short) 20862, "Чили"),
    PACIFIC_EFATE_WANATUTU("Pacific/Efate", (short) 161, (short) 21556, "Вануату"),
    PACIFIC_EFATE_SOLOMON("Pacific/Efate", (short) 52, (short) 20915, "Соломоновы острова"),
    PACIFIC_FIJI("Pacific/Fiji", (short) 14, (short) 10030, "Фиджи"),
    PACIFIC_FUNAFUTI("Pacific/Funafuti", (short) 231, (short) 21601, "Тувалу"),
    PACIFIC_GUAM("Pacific/Guam", (short) 245, (short) 20747, "Гуам"),
    PACIFIC_HONOLULU("Pacific/Honolulu", (short) 40, (short) 84, "США"),
    PACIFIC_MAJURO("Pacific/Majuro", (short) 63, (short) 21578, "Маршалловы острова"),
    PACIFIC_NAURU("Pacific/Nauru", (short) 194, (short) 21582, "Науру"),
    PACIFIC_NIUE("Pacific/Niue", (short) 196, (short) 98542, "Ниуэ"),
    PACIFIC_NOUMEA("Pacific/Noumea", (short) 213, (short) 21584, "Новая Каледония"),
    PACIFIC_PALAU("Pacific/Palau", (short) 204, (short) 21589, "Палау"),
    PACIFIC_PORT_MORESBY("Pacific/Port_Moresby", (short) 259, (short) 20739, "Папуа-Новая Гвинея"),
    PACIFIC_RAROTONGA("Pacific/Rarotonga", (short) 96, (short) 21574, "Острова Кука"),
    PACIFIC_TAHITI("Pacific/Tahiti", (short) 171, (short) 21330, "Французская Полинезия"),
    PACIFIC_TARAWA("Pacific/Tarawa", (short) 190, (short) 21572, "Кирибати"),
    PACIFIC_TONGATAPU("Pacific/Tongatapu", (short) 70, (short) 21599, "Тонга"),
    PACIFIC_YAP("Pacific/Yap", (short) 230, (short) 21580, "Федеративные Штаты Микронезии");


    private String timeZone;
    private short timezoneId;
    private short countryId;
    private String country;

    TimeZoneCountryEnum(String timeZone, Short timezoneId, Short countryId, String country) {
        this.timeZone = timeZone;
        this.timezoneId = timezoneId;
        this.countryId = countryId;
        this.country = country;
    }

    public String getTimeZone() {
        return timeZone;
    }

    public short getTimezoneId() {
        return timezoneId;
    }

    public short getCountryId() {
        return countryId;
    }

    public String getCountry() {
        return country;
    }

    @Override
    public String toString() {
        return "timezone:" + getTimeZone() + ", (short) countryId: " + getCountryId() + ", (short) country:" + getCountry();
    }

}
