package ru.yandex.autotests.directapi.darkside.model.bmapi.request;

import org.json.JSONObject;
import ru.yandex.autotests.irt.testutils.json.JsonUtils;

import java.util.HashMap;

/**
 * Created by pavryabov on 04.08.15.
 */
public class BmapiRequest extends HashMap {

    private static final String CMD = "cmd";
    private static final String URL = "url";
    private static final String LOGIN = "login";
    private static final String PASS = "pass";
    private static final String MAX_FILE_SIZE = "max_file_size";
    private static final String MAX_FILE_SIZE_TYPE = "max_file_size_type";
    private static final String FILTERS = "filters";
    private static final String BUSINESS_TYPE = "business_type";

    private static final String YML2DIRECTINF = "yml2directinf";
    private static final String YML2FILTERED = "yml2filtered";

    public BmapiRequest withCmd(String cmd) {
        put(CMD, cmd);
        return this;
    }

    public BmapiRequest yml2DirectInf() {
        return this.withCmd(YML2DIRECTINF);
    }

    public BmapiRequest yml2Filtered() {
        return this.withCmd(YML2FILTERED);
    }

    public BmapiRequest withUrl(String url) {
        put(URL, url);
        return this;
    }

    public BmapiRequest withLogin(String login) {
        put(LOGIN, login);
        return this;
    }

    public BmapiRequest withPass(String pass) {
        put(PASS, pass);
        return this;
    }

    public BmapiRequest withMaxFileSize(String maxFileSize) {
        put(MAX_FILE_SIZE, maxFileSize);
        return this;
    }

    public BmapiRequest withMaxFileSizeType(String maxFileSizeType) {
        put(MAX_FILE_SIZE_TYPE, maxFileSizeType);
        return this;
    }

    public BmapiRequest withFilters(Filters filters) {
        put(FILTERS, filters.toString());
        return this;
    }

    public BmapiRequest withBusinessType(String businessType) {
        put(BUSINESS_TYPE, businessType);
        return this;
    }
}
