package ru.yandex.autotests.directapi.darkside.model.bmapi.request;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlValue;

/**
 * Created by pavryabov on 06.08.15.
 */
@XmlRootElement
public class Category {

    private String id;
    private String parentId;
    private String name;

    public Category(){}

    public Category(String id, String parentId, String name) {
        this.id = id;
        this.parentId = parentId;
        this.name = name;
    }

    @XmlAttribute
    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @XmlAttribute
    public String getParentId() {
        return parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    @XmlValue
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Category withId(String id) {
        this.id = id;
        return this;
    }

    public Category withParentId(String parentId) {
        this.parentId = parentId;
        return this;
    }

    public Category withName(String name) {
        this.name = name;
        return this;
    }
}
