package ru.yandex.autotests.directapi.darkside.model.bmapi.request;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

/**
 * Created by pavryabov on 07.08.15.
 */
@XmlRootElement
public class Offer {

    private String id;
    private Boolean available;
    private String name;
    private String vendor;
    private String categoryId;
    private String url;

    @XmlAttribute
    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @XmlAttribute
    public Boolean getAvailable() {
        return available;
    }

    public void setAvailable(Boolean available) {
        this.available = available;
    }

    @XmlElement
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @XmlElement
    public String getVendor() {
        return vendor;
    }

    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    @XmlElement
    public String getCategoryId() {
        return categoryId;
    }

    public void setCategoryId(String categoryId) {
        this.categoryId = categoryId;
    }

    @XmlElement
    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Offer withId(String id) {
        this.id = id;
        return this;
    }

    public Offer withAvailable(Boolean available) {
        this.available = available;
        return this;
    }

    public Offer withName(String name) {
        this.name = name;
        return this;
    }

    public Offer withVendor(String vendor) {
        this.vendor = vendor;
        return this;
    }

    public Offer withCategoryId(String categoryId) {
        this.categoryId = categoryId;
        return this;
    }

    public Offer withUrl(String url) {
        this.url = url;
        return this;
    }
}
