package ru.yandex.autotests.directapi.darkside.model.bmapi.response;

import com.google.gson.annotations.SerializedName;
import ru.yandex.autotests.irt.testutils.json.JsonUtils;

import java.lang.*;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

/**
 * Created by pavryabov on 10.08.15.
 */
public class BmapiResponse {

    @SerializedName("vendor")
    HashMap<String, Integer> vendor;

    @SerializedName("categoryId")
    HashMap<String, Integer> categoryId;

    @SerializedName("errors")
    List<Error> errors;

    @SerializedName("warnings")
    List<Error> warnings;

    @SerializedName("categs")
    List<ItemOfCategs> categs;

    @SerializedName("all_elements_amount")
    Integer allElementsAmount;

    @SerializedName("file_data")
    String fileData;

    public HashMap<String, Integer> getVendor() {
        return vendor;
    }

    public void setVendor(HashMap<String, Integer> vendor) {
        this.vendor = vendor;
    }

    public HashMap<String, Integer> getCategoryId() {
        return categoryId;
    }

    public void setCategoryId(HashMap<String, Integer> categoryId) {
        this.categoryId = categoryId;
    }

    public List<Error> getErrors() {
        return errors;
    }

    public void setErrors(List<Error> errors) {
        this.errors = errors;
    }

    public List<Error> getWarnings() {
        return warnings;
    }

    public void setWarnings(List<Error> warnings) {
        this.warnings = warnings;
    }

    public List<ItemOfCategs> getCategs() {
        return categs;
    }

    public void setCategs(List<ItemOfCategs> categs) {
        this.categs = categs;
    }

    public Integer getAllElementsAmount() {
        return allElementsAmount;
    }

    public void setAllElementsAmount(Integer allElementsAmount) {
        this.allElementsAmount = allElementsAmount;
    }

    public String getFileData() {
        return fileData;
    }

    public void setFileData(String fileData) {
        this.fileData = fileData;
    }

    public BmapiResponse withVendor(HashMap<String, Integer> vendor) {
        this.vendor = vendor;
        return this;
    }

    public BmapiResponse withVendor(ItemOfVendor... itemOfVendors) {
        HashMap<String, Integer> vendor = new HashMap<String, Integer>();
        for (ItemOfVendor itemOfVendor : itemOfVendors) {
            vendor.put(itemOfVendor.getVendor(), itemOfVendor.getAmount());
        }
        this.vendor = vendor;
        return this;
    }

    public BmapiResponse withCategoryId(HashMap<String, Integer> categoryId) {
        this.categoryId = categoryId;
        return this;
    }

    public BmapiResponse withCategoryId(ItemOfCategoryId... itemOfCategoryIds) {
        HashMap<String, Integer> categoryId = new HashMap<String, Integer>();
        for (ItemOfCategoryId itemOfCategoryId : itemOfCategoryIds) {
            categoryId.put(itemOfCategoryId.getId(), itemOfCategoryId.getAmount());
        }
        this.categoryId = categoryId;
        return this;
    }

    public BmapiResponse withErrors(Error... errors) {
        this.errors = Arrays.asList(errors);
        return this;
    }

    public BmapiResponse withWarnings(Error... warnings) {
        this.warnings = Arrays.asList(warnings);
        return this;
    }

    public BmapiResponse withCategs(ItemOfCategs... categs) {
        this.categs = Arrays.asList(categs);
        return this;
    }

    public BmapiResponse withAllElementsAmount(Integer allElementsAmount) {
        this.allElementsAmount = allElementsAmount;
        return this;
    }

    public BmapiResponse withFileData(String fileData) {
        this.fileData = fileData;
        return this;
    }

    public BmapiResponse withEmptyErrors() {
        return this.withErrors(new Error[]{});
    }

    public BmapiResponse withEmptyWarnings() {
        return this.withWarnings(new Error[]{});
    }

    @Override
    public String toString() {
        return JsonUtils.toString(this);
    }
}
