package ru.yandex.autotests.directapi.darkside.model.bmapi.response;

import com.google.gson.annotations.SerializedName;
import ru.yandex.autotests.irt.testutils.json.JsonUtils;

/**
 * Created by pavryabov on 10.08.15.
 */
public class Error {

    public static final Integer DOWNLOAD_ERROR = 1201;
    public static final Integer PAGE_IS_NOT_XML = 1202;
    public static final Integer NO_MODEL_OR_NAME = 1203;
    public static final Integer XML_FATAL = 1204;
    public static final Integer NO_OFFERS = 1205;
    public static final Integer NO_CATEGORIES = 1206;
    public static final Integer FEED_TYPE_MISMATCH = 1212;
    public static final Integer XML_PARSE_ERROR = 1217;
    public static final Integer TOO_BIG_FILE = 1266;

    @SerializedName("code")
    Integer code;
    @SerializedName("message")
    String message;

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Error withCode(Integer code) {
        this.code = code;
        return this;
    }

    public Error withMessage(String message) {
        this.message = message;
        return this;
    }

    @Override
    public String toString() {
        return JsonUtils.toString(this);
    }
}
