package ru.yandex.autotests.directapi.darkside.model.bslogs;

import com.yandex.direct.api.v5.general.PriorityEnum;

public enum AutoBudgetPriority {

    LOW("Low", PriorityEnum.LOW, "1"),
    MEDIUM("Medium", PriorityEnum.NORMAL, "3"),
    HIGH("High", PriorityEnum.HIGH, "5");


    private AutoBudgetPriority(String apiValue, PriorityEnum api5Value, String transportValue) {
        this.apiValue = apiValue;
        this.api5Value = api5Value;
        this.transportValue = transportValue;
    }

    private String apiValue;
    private PriorityEnum api5Value;
    private String transportValue;

    public String apiValue() {
        return apiValue;
    }

    public PriorityEnum api5Value() {
        return api5Value;
    }

    public String transportValue() {
        return transportValue;
    }

    @Override
    public String toString() {
        return apiValue;
    }
}
