package ru.yandex.autotests.directapi.darkside.model.bslogs;

public enum RelevantPhrasesBudgetLimit {

    LIMIT_OFF(null, 0),
    LIMIT_10(10, 10),
    LIMIT_20(20, 20),
    LIMIT_30(30, 30),
    LIMIT_40(40, 40),
    LIMIT_50(50, 50),
    LIMIT_60(60, 60),
    LIMIT_70(70, 70),
    LIMIT_80(80, 80),
    LIMIT_90(90, 90),
    LIMIT_100(100, 100),
    UNLIMITED(-1, 100);

    private Integer apiRelevantPhrasesBudgetLimit;
    private Integer transportBroadMatchLimit;

    private RelevantPhrasesBudgetLimit(Integer apiValue, Integer transportValue) {
        this.apiRelevantPhrasesBudgetLimit = apiValue;
        this.transportBroadMatchLimit = transportValue;
    }

    public Integer apiRelevantPhrasesBudgetLimit() {
        return apiRelevantPhrasesBudgetLimit;
    }

    public Integer transportBroadMatchLimit() {
        return transportBroadMatchLimit;
    }

    @Override
    public String toString() {
        return "" + apiRelevantPhrasesBudgetLimit;
    }
}
