package ru.yandex.autotests.directapi.darkside.model.bslogs;

import com.yandex.direct.api.v5.campaigns.DailyBudgetModeEnum;

public enum SpendMode {

    DEFAULT("Default", DailyBudgetModeEnum.STANDARD, 0),
    STRETCHED("Stretched", DailyBudgetModeEnum.DISTRIBUTED, 1);

    private String apiSpendMode;
    private DailyBudgetModeEnum api5SpendMode;
    private Integer transportRegularSpent;

    private SpendMode(String apiValue, DailyBudgetModeEnum api5Value, Integer transportValue) {
        this.apiSpendMode = apiValue;
        this.api5SpendMode = api5Value;
        this.transportRegularSpent = transportValue;
    }

    public String apiSpendMode() {
        return apiSpendMode;
    }

    public DailyBudgetModeEnum api5SpendMode() {
        return api5SpendMode;
    }

    public Integer transportRegularSpent() {
        return transportRegularSpent;
    }

    @Override
    public String toString() {
        return apiSpendMode;
    }
}
