package ru.yandex.autotests.directapi.darkside.model.bslogs.campsums;

import com.google.gson.annotations.SerializedName;
import ru.yandex.autotests.direct.utils.money.Currency;

/**
 * Created by omaz on 08.05.14.
 */
public class CampSumsTransportRequest {

    @SerializedName("OrderID")
    Long orderId;
    @SerializedName("CurrencyISOCode")
    Integer currencyIsoCode;
    @SerializedName("CurrencyConvertDate")
    String currencyConvertDate;
    @SerializedName("SUMCur")
    Double sumCur;
    @SerializedName("SUM")
    Double sum;
    @SerializedName("QueueSetTime")
    String queueSetTime;


    public CampSumsTransportRequest() {
    }

    public CampSumsTransportRequest(Long orderId,
                                    Integer currencyIsoCode,
                                    String currencyConvertDate,
                                    Double sum) {
        this.orderId = orderId;
        this.currencyIsoCode = currencyIsoCode;
        this.currencyConvertDate = currencyConvertDate;
        if (currencyIsoCode == Currency.YND_FIXED.getIsoCode()) {
            this.sumCur = 0.;
            this.sum = sum;
        } else {
            this.sum = 0.;
            this.sumCur = sum;
        }
    }


    public Long getOrderId() {
        return orderId;
    }

    public void setOrderId(Long orderId) {
        this.orderId = orderId;
    }

    public Integer getCurrencyIsoCode() {
        return currencyIsoCode;
    }

    public void setCurrencyIsoCode(Integer currencyIsoCode) {
        this.currencyIsoCode = currencyIsoCode;
    }

    public String getCurrencyConvertDate() {
        return currencyConvertDate;
    }

    public void setCurrencyConvertDate(String currencyConvertDate) {
        this.currencyConvertDate = currencyConvertDate;
    }

    public Double getSumCur() {
        return sumCur;
    }

    public void setSumCur(Double sumCur) {
        this.sumCur = sumCur;
    }

    public Double getSum() {
        return sum;
    }

    public void setSum(Double sum) {
        this.sum = sum;
    }

    public String getQueueSetTime() {
        return queueSetTime;
    }

    public void setQueueSetTime(String queueSetTime) {
        this.queueSetTime = queueSetTime;
    }
}
