package ru.yandex.autotests.directapi.darkside.model.bslogs.campsums;

import com.google.gson.annotations.SerializedName;
import ru.yandex.autotests.directapi.darkside.exceptions.DarkSideException;

import java.util.ArrayList;
import java.util.List;

import static ch.lambdaj.Lambda.*;
import static org.hamcrest.Matchers.equalTo;

public class CampSumsTransportResponse {

    public static class Order {
        @SerializedName("ID")
        Long orderId;
        @SerializedName("Error")
        Integer error;
        @SerializedName("ErrorMessage")
        String errorMessage;

        public Long getOrderId() {
            return orderId;
        }

        public void setOrderId(Long orderId) {
            this.orderId = orderId;
        }

        public Integer getError() {
            return error;
        }

        public void setError(Integer error) {
            this.error = error;
        }

        public String getErrorMessage() {
            return errorMessage;
        }

        public void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }
    }

    @SerializedName("ORDERS")
    List<Order> orders = new ArrayList<>();
    @SerializedName("Error")
    Integer error;
    @SerializedName("ErrorMessage")
    String errorMessage;
    @SerializedName("UNDONE")
    String undone;

    public Order getOrder(Long orderId) {
        Order order =
                selectFirst(orders, having(on(Order.class).getOrderId(), equalTo(orderId)));
        if (order == null) {
            throw new DarkSideException("Заказ " + orderId + " не найден в ответе БК");
        }
        return order;
    }

    public Integer getError() {
        return error;
    }

    public String getErrorMessage() {
        return errorMessage;
    }

    public String getUndone() {
        return undone;
    }
}
