package ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;

import ru.yandex.autotests.directapi.darkside.model.bslogs.BannerTemplateId;

public class Banner {

    public static final String TITLE = "Title";
    public static final String TITLE_EXTENSION = "TitleExtension";
    public static final String AGE = "Age";
    public static final String LANG = "Lang";
    public static final String SITE = "Site";
    public static final String SITE_FILTER = "SiteFilter";
    public static final String HREF = "Href";
    public static final String HREF_TEXT = "HrefText";
    public static final String DOMAIN_FILTER = "DomainFilter";
    public static final String MARKET_RATING = "MarketRating";
    public static final String PICTURE = "Picture";
    public static final String PICTURE_MD5 = "PictureMD5";
    public static final String CALLOUT_SET = "CalloutSet";
    public static final String DYNAMIC_DISCLAIMER = "DynamicDisclaimer";
    public static final String UPDATE_INFO = "UpdateInfo";
    public static final String IS_AUTO_VIDEO = "IsAutoVideo";
    public static final String RESOURCES = "Resources";
    public static final String PERMALINK = "Permalink";
    public static final String PERMALINK_AD_PHONE = "PermalinkAdPhone";
    public static final String CHAIN_IDS = "PermalinkChainIDs";
    public static final String CREATIVE_WITH_STATUS = "CreativesWithStatus";
    public static final String IS_VIDEO_CREATIVE = "IsVideoCreative";
    public static final String IS_PERFORMANCE_MAIN = "IsPerformanceMain";
    public static final String STRATEGY_ID = "StrategyID";

    @SerializedName("ID")
    private String id;

    @SerializedName("EID")
    private String eid;

    @SerializedName("ParentExportID")
    private String parentExportId;

    @SerializedName("Dynamic")
    private Integer dynamic;

    @SerializedName("Flags")
    private String flags;

    @SerializedName(AGE)
    private String age;

    @SerializedName("PriorityID")
    private String priorityId;

    @SerializedName(TITLE)
    private String title;

    @SerializedName(TITLE_EXTENSION)
    private String titleExtension;

    @SerializedName("GeoFlag")
    private String geoFlag;

    @SerializedName("Sitelinks")
    private List<Sitelink> sitelinks = new ArrayList<>();

    @SerializedName("Body")
    private String body;

    @SerializedName(LANG)
    private String lang;

    @SerializedName("ContactInfo")
    private ContactInfo contactInfo;

    @SerializedName("HideDomain")
    private String hideDomain;

    @SerializedName(SITE)
    private String site;

    @SerializedName(UPDATE_INFO)
    private Integer updateInfo;

    @SerializedName(DOMAIN_FILTER)
    private String domainFilter;

    @SerializedName("BannerLandData")
    private String bannerLandData;

    @SerializedName(HREF)
    private String href;

    @SerializedName("HrefS2S")
    private String hrefS2S;

    @SerializedName(HREF_TEXT)
    private String HrefText;

    @SerializedName("ContentStoreHref")
    private String contentStoreHref;

    @SerializedName("ContentStoreHrefS2S")
    private String contentStoreHrefS2S;

    @SerializedName("MobileTracker")
    private String mobileTracker;

    @SerializedName("Stop")
    private Integer stop;

    @SerializedName("Archive")
    private Integer archive;

    @SerializedName(SITE_FILTER)
    private String siteFilter;

    @SerializedName("Picture")
    private String picture;

    @SerializedName("PictureMD5")
    private String pictureMD5;

    @SerializedName("Images")
    private Images images;

    @SerializedName("Mobile")
    private Integer mobile;

    @SerializedName(MARKET_RATING)
    private Integer marketRating;

    @SerializedName("MobileAppID")
    private Long mobileAppID;

    @SerializedName("ContentAction")
    private String contentAction;

    @SerializedName("HideContentIcon")
    private Integer hideContentIcon;

    @SerializedName("HideStoreContentRating")
    private Integer hideStoreContentRating;

    @SerializedName("HideStoreContentPrice")
    private Integer hideStoreContentPrice;

    @SerializedName("HideContentReviewCount")
    private Integer hideContentReviewCount;

    @SerializedName("Creative")
    private List<Long> creative;

    @SerializedName(CREATIVE_WITH_STATUS)
    private List<CreativeWithStatus> creativeWithStatus;

    @SerializedName("ImageType")
    private String imageType;

    @SerializedName(CALLOUT_SET)
    private CalloutSet calloutSet;

    @SerializedName("Resources")
    private Resources resources;

    @SerializedName("IsMediaImage")
    private Integer isMediaImage;

    @SerializedName("MediaImage")
    private String[] mediaImage;

    @SerializedName("IsMediaCreative")
    private Integer isMediaCreative;

    @SerializedName("DynamicDisclaimer")
    private String dynamicDisclaimer;

    @SerializedName("IsAutoVideo")
    private Integer isAutoVideo;

    @SerializedName("IsVideoCreative")
    private Integer isVideoCreative;

    @SerializedName("IsVideoCreativeOutdoor")
    private Integer isVideoCreativeOutdoor;

    @SerializedName("IsVideoCreativeIndoor")
    private Integer isVideoCreativeIndoor;

    @SerializedName("IsAudioCreative")
    private Integer isAudioCreative;

    @SerializedName("TemplateID")
    private Integer templateId;

    @SerializedName("DistributionFormatID")
    private Long distributionFormatId;

    @SerializedName("Permalink")
    private Long permalink;

    @SerializedName("PermalinkAdPhone")
    private String permalinkAdPhone;

    @SerializedName("PermalinkChainIDs")
    private List<Long> chainIds;

    @SerializedName("ViewNoticeHrefs")
    private List<String> viewNoticeHrefs;

    @SerializedName("BannerPrice")
    private BannerPrice bannerPrice;

    @SerializedName("PageModeration")
    private List<PageModeration> pageModeration;

    @SerializedName("MdsMeta")
    private MdsMeta mdsMeta;

    @SerializedName("TargetDomain")
    private String targetDomain;

    @SerializedName("SiteFilterID")
    private Integer siteFilterID;

    @SerializedName("DomainFilterID")
    private Integer domainFilterID;

    @SerializedName("TargetDomainID")
    private Integer targetDomainID;

    @SerializedName("Measurers")
    private Map<String, Object> measurers;

    @SerializedName("IsNewBanner")
    private Integer isNewBanner;

    @SerializedName("DisplayedDomainAlias")
    private String displayedDomainAlias;

    @SerializedName("IsFakeTitle")
    private Integer isFakeTitle;

    @SerializedName("IsFakeBody")
    private Integer isFakeBody;

    @SerializedName("ImpressionUrl")
    private String impressionUrl;

    @SerializedName(IS_PERFORMANCE_MAIN)
    private Integer isPerformanceMain;

    @SerializedName(STRATEGY_ID)
    private Long strategyId;

    public Integer getIsNewBanner() {
        return isNewBanner;
    }

    public void setIsNewBanner(Integer isNewBanner) {
        this.isNewBanner = isNewBanner;
    }

    public Integer getSiteFilterID() {
        return siteFilterID;
    }

    public void setSiteFilterID(Integer siteFilterID) {
        this.siteFilterID = siteFilterID;
    }

    public Integer getDomainFilterID() {
        return domainFilterID;
    }

    public void setDomainFilterID(Integer domainFilterID) {
        this.domainFilterID = domainFilterID;
    }

    public Integer getTargetDomainID() {
        return targetDomainID;
    }

    public void setTargetDomainID(Integer targetDomainID) {
        this.targetDomainID = targetDomainID;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getEid() {
        return eid;
    }

    public void setEid(String eid) {
        this.eid = eid;
    }

    public String getParentExportId() {
        return parentExportId;
    }

    public void setParentExportId(String parentExportId) {
        this.parentExportId = parentExportId;
    }

    public Integer getDynamic() {
        return dynamic;
    }

    public void setDynamic(Integer dynamic) {
        this.dynamic = dynamic;
    }

    public String getFlags() {
        return flags;
    }

    public void setFlags(String flags) {
        this.flags = flags;
    }

    public String getAge() {
        return age;
    }

    public void setAge(String age) {
        this.age = age;
    }

    public String getPriorityId() {
        return priorityId;
    }

    public void setPriorityId(String priorityId) {
        this.priorityId = priorityId;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitleExtension() {
        return titleExtension;
    }

    public void setTitleExtension(String titleExtension) {
        this.titleExtension = titleExtension;
    }

    public String getGeoFlag() {
        return geoFlag;
    }

    public void setGeoFlag(String geoFlag) {
        this.geoFlag = geoFlag;
    }

    public List<Sitelink> getSitelinks() {
        return sitelinks;
    }

    public void setSitelinks(List<Sitelink> sitelinks) {
        this.sitelinks = sitelinks;
    }

    public String getBody() {
        return body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public String getLang() {
        return lang;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    public ContactInfo getContactInfo() {
        return contactInfo;
    }

    public void setContactInfo(ContactInfo contactInfo) {
        this.contactInfo = contactInfo;
    }

    public String getHideDomain() {
        return hideDomain;
    }

    public void setHideDomain(String hideDomain) {
        this.hideDomain = hideDomain;
    }

    public String getSite() {
        return site;
    }

    public void setSite(String site) {
        this.site = site;
    }

    public Integer getUpdateInfo() {
        return updateInfo;
    }

    public void setUpdateInfo(Integer updateInfo) {
        this.updateInfo = updateInfo;
    }

    public String getDomainFilter() {
        return domainFilter;
    }

    public void setDomainFilter(String domainFilter) {
        this.domainFilter = domainFilter;
    }

    public String getHref() {
        return href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public String getHrefS2S() {
        return hrefS2S;
    }

    public void setHrefS2S(String hrefS2S) {
        this.hrefS2S = hrefS2S;
    }

    public String getContentStoreHref() {
        return contentStoreHref;
    }

    public void setContentStoreHref(String contentStoreHref) {
        this.contentStoreHref = contentStoreHref;
    }

    public String getContentStoreHrefS2S() {
        return contentStoreHrefS2S;
    }

    public void setContentStoreHrefS2S(String contentStoreHrefS2S) {
        this.contentStoreHrefS2S = contentStoreHrefS2S;
    }

    public String getMobileTracker() {
        return mobileTracker;
    }

    public void setMobileTracker(String mobileTracker) {
        this.mobileTracker = mobileTracker;
    }

    public Integer getStop() {
        return stop;
    }

    public void setStop(Integer stop) {
        this.stop = stop;
    }

    public Integer getArchive() {
        return archive;
    }

    public void setArchive(Integer archive) {
        this.archive = archive;
    }

    public String getSiteFilter() {
        return siteFilter;
    }

    public void setSiteFilter(String siteFilter) {
        this.siteFilter = siteFilter;
    }

    public String getPicture() {
        return picture;
    }

    public void setPicture(String picture) {
        this.picture = picture;
    }

    public String getPictureMD5() {
        return pictureMD5;
    }

    public void setPictureMD5(String pictureMD5) {
        this.pictureMD5 = pictureMD5;
    }

    public Images getImages() {
        return images;
    }

    public void setImages(Images images) {
        this.images = images;
    }

    public Integer getMobile() {
        return mobile;
    }

    public void setMobile(Integer mobile) {
        this.mobile = mobile;
    }

    public String getBannerLandData() {
        return bannerLandData;
    }

    public void setBannerLandData(String bannerLandData) {
        this.bannerLandData = bannerLandData;
    }

    public Long getMobileAppID() {
        return mobileAppID;
    }

    public void setMobileAppID(Long mobileAppID) {
        this.mobileAppID = mobileAppID;
    }

    public String getContentAction() {
        return contentAction;
    }

    public void setContentAction(String contentAction) {
        this.contentAction = contentAction;
    }

    public Integer getHideContentIcon() {
        return hideContentIcon;
    }

    public void setHideContentIcon(Integer hideContentIcon) {
        this.hideContentIcon = hideContentIcon;
    }

    public Integer getHideStoreContentRating() {
        return hideStoreContentRating;
    }

    public void setHideStoreContentRating(Integer hideStoreContentRating) {
        this.hideStoreContentRating = hideStoreContentRating;
    }

    public Integer getHideStoreContentPrice() {
        return hideStoreContentPrice;
    }

    public void setHideStoreContentPrice(Integer hideStoreContentPrice) {
        this.hideStoreContentPrice = hideStoreContentPrice;
    }

    public Integer getHideContentReviewCount() {
        return hideContentReviewCount;
    }

    public void setHideContentReviewCount(Integer hideContentReviewCount) {
        this.hideContentReviewCount = hideContentReviewCount;
    }

    public List<Long> getCreative() {
        return creative;
    }

    public void setCreative(List<Long> creative) {
        this.creative = creative;
    }

    public Banner withCreative(List<Long> creative) {
        this.creative = creative;
        return this;
    }

    public String getImageType() {
        return imageType;
    }

    public void setCalloutSet(CalloutSet calloutSet) {
        this.calloutSet = calloutSet;
    }

    public CalloutSet getCalloutSet() {
        return calloutSet;
    }

    public void setImageType(String imageType) {
        this.imageType = imageType;
    }

    public void setHrefText(String hrefText) {
        HrefText = hrefText;
    }

    public String getHrefText() {
        return HrefText;
    }

    public Resources getResources() {
        return resources;
    }

    public void setResources(Resources resources) {
        this.resources = resources;
    }

    public Banner withResources(Resources resources) {
        this.resources = resources;
        return this;
    }

    public Integer getIsMediaImage() {
        return isMediaImage;
    }

    public void setIsMediaImage(Integer isMediaImage) {
        this.isMediaImage = isMediaImage;
    }

    public Banner withIsMediaImage(Integer isMediaImage) {
        this.isMediaImage = isMediaImage;
        return this;
    }

    public String[] getMediaImage() {
        return mediaImage;
    }

    public void setMediaImage(String[] mediaImage) {
        this.mediaImage = mediaImage;
    }

    public Banner withMediaImage(String[] mediaImage) {
        this.mediaImage = mediaImage;
        return this;
    }

    public Integer getIsMediaCreative() {
        return isMediaCreative;
    }

    public void setIsMediaCreative(Integer isMediaCreative) {
        this.isMediaCreative = isMediaCreative;
    }

    public Integer getMarketRating() {
        return marketRating;
    }

    public void setMarketRating(Integer marketRating) {
        this.marketRating = marketRating;
    }

    public String getDynamicDisclaimer() {
        return dynamicDisclaimer;
    }

    public void setDynamicDisclaimer(String dynamicDisclaimer) {
        this.dynamicDisclaimer = dynamicDisclaimer;
    }

    public Integer getIsAutoVideo() {
        return isAutoVideo;
    }

    public void setIsAutoVideo(Integer isAutoVideo) {
        this.isAutoVideo = isAutoVideo;
    }

    public Banner withIsAutoVideo(Integer isAutoVideo) {
        this.isAutoVideo = isAutoVideo;
        return this;
    }

    public Integer getIsVideoCreative() {
        return isVideoCreative;
    }

    public void setIsVideoCreative(Integer isVideoCreative) {
        this.isVideoCreative = isVideoCreative;
    }

    public Banner withIsVideoCreative(Integer isVideoCreative) {
        this.isVideoCreative = isVideoCreative;
        return this;
    }

    public Integer getIsVideoCreativeOutdoor() {
        return isVideoCreativeOutdoor;
    }

    public void setIsVideoCreativeOutdoor(Integer isVideoCreativeOutdoor) {
        this.isVideoCreativeOutdoor = isVideoCreativeOutdoor;
    }

    public Banner withIsVideoCreativeOutdoor(Integer isVideoCreativeOutdoor) {
        isVideoCreativeOutdoor = isVideoCreativeOutdoor;
        return this;
    }

    public Integer getIsVideoCreativeIndoor() {
        return isVideoCreativeIndoor;
    }

    public void setIsVideoCreativeIndoor(Integer isVideoCreativeIndoor) {
        this.isVideoCreativeIndoor = isVideoCreativeIndoor;
    }

    public Integer getIsAudioCreative() {
        return isAudioCreative;
    }

    public void setIsAudioCreative(Integer isAudioCreative) {
        this.isAudioCreative = isAudioCreative;
    }

    public Integer getTemplateId() {
        return templateId;
    }

    public void setTemplateId(Integer templateId) {
        this.templateId = templateId;
    }

    public Banner withTemplateId(BannerTemplateId templateId) {
        this.templateId = templateId.value();
        return this;
    }

    public Banner withTemplateId(Integer templateId) {
        this.templateId = templateId;
        return this;
    }

    public Long getDistributionFormatId() {
        return distributionFormatId;
    }

    public void setDistributionFormatId(Long distributionFormatId) {
        this.distributionFormatId = distributionFormatId;
    }

    public Banner withDistributionFormatId(Long distributionFormatId) {
        this.distributionFormatId = distributionFormatId;
        return this;
    }

    public Long getPermalink() {
        return permalink;
    }

    public void setPermalink(Long permalink) {
        this.permalink = permalink;
    }

    public Banner withPermalink(Long permalink) {
        this.permalink = permalink;
        return this;
    }

    public String getPermalinkAdPhone() {
        return permalinkAdPhone;
    }

    public void setPermalinkAdPhone(String permalinkAdPhone) {
        this.permalinkAdPhone = permalinkAdPhone;
    }

    public Banner withPermalinkAdPhone(String permalinkAdPhone) {
        this.permalinkAdPhone = permalinkAdPhone;
        return this;
    }

    public List<String> getViewNoticeHrefs() {
        return viewNoticeHrefs;
    }

    public void setViewNoticeHrefs(List<String> viewNoticeHrefs) {
        this.viewNoticeHrefs = viewNoticeHrefs;
    }

    public String asJson() {
        return new Gson().toJson(this);
    }

    public List<CreativeWithStatus> getCreativeWithStatus() {
        return creativeWithStatus;
    }

    public void setCreativeWithStatus(
            List<CreativeWithStatus> creativeWithStatus) {
        this.creativeWithStatus = creativeWithStatus;
    }

    public Banner withCreativeWithStatus(List<CreativeWithStatus> creativeWithStatus) {
        this.creativeWithStatus = creativeWithStatus;
        return this;
    }

    public List<Long> getChainIds() {
        return chainIds;
    }

    public void setChainIds(List<Long> chainIds) {
        this.chainIds = chainIds;
    }

    public BannerPrice getBannerPrice() {
        return bannerPrice;
    }

    public void setBannerPrice(BannerPrice bannerPrice) {
        this.bannerPrice = bannerPrice;
    }

    public Banner withBannerPrice(BannerPrice bannerPrice) {
        this.bannerPrice = bannerPrice;
        return this;
    }

    public List<PageModeration> getPageModeration() {
        return pageModeration;
    }

    public void setPageModeration(List<PageModeration> pageModeration) {
        this.pageModeration = pageModeration;
    }

    public Banner withPageModeration(List<PageModeration> pageModeration) {
        this.pageModeration = pageModeration;
        return this;
    }

    /**
     * Если потребовалась MdsMeta - для получения запроса нужно вызавать метод getClientDataRequestCampaignWithMdsMeta
     * (тот, что без замены MdsMeta на его хеш в поле MdsMetaStub - где в параметрах isOmitMdsMeta = false)
     */
    public MdsMeta getMdsMeta() {
        return mdsMeta;
    }

    public void setMdsMeta(MdsMeta mdsMeta) {
        this.mdsMeta = mdsMeta;
    }

    public Banner withMdsMeta(MdsMeta mdsMeta) {
        this.mdsMeta = mdsMeta;
        return this;
    }

    public String getTargetDomain() {
        return targetDomain;
    }

    public void setTargetDomain(String targetDomain) {
        this.targetDomain = targetDomain;
    }

    public Map<String, Object> getMeasurers() {
        return measurers;
    }

    public void setMeasurers(Map<String, Object> measurers) {
        this.measurers = measurers;
    }

    public String getDisplayedDomainAlias() {
        return displayedDomainAlias;
    }

    public void setDisplayedDomainAlias(String displayedDomainAlias) {
        this.displayedDomainAlias = displayedDomainAlias;
    }

    public Integer getIsFakeTitle() {
        return isFakeTitle;
    }

    public void setIsFakeTitle(Integer isFakeTitle) {
        this.isFakeTitle = isFakeTitle;
    }

    public Integer getIsFakeBody() {
        return isFakeBody;
    }

    public void setIsFakeBody(Integer isFakeBody) {
        this.isFakeBody = isFakeBody;
    }

    public String getImpressionUrl() {
        return impressionUrl;
    }

    public void setImpressionUrl(String impressionUrl) {
        this.impressionUrl = impressionUrl;
    }

    public Integer getIsPerformanceMain() {
        return isPerformanceMain;
    }

    public Banner withIsPerformanceMain(Integer isPerformanceMain) {
        this.isPerformanceMain = isPerformanceMain;
        return this;
    }

    public Long getStrategyId() {
        return strategyId;
    }

    public void setStrategyId(Long strategyId) {
        this.strategyId = strategyId;
    }
}
