package ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata;

import java.math.BigDecimal;

import com.google.gson.annotations.SerializedName;

import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannerPricesCurrency;

public class BannerPrice {
    @SerializedName("Price")
    private BigDecimal price;
    @SerializedName("OldPrice")
    private BigDecimal oldPrice;
    @SerializedName("Prefix")
    private String prefix;
    @SerializedName("Currency")
    private BannerPricesCurrency currency;

    public BigDecimal getPrice() {
        return price;
    }

    public BannerPrice withPrice(BigDecimal price) {
        this.price = price;
        return this;
    }

    public BigDecimal getOldPrice() {
        return oldPrice;
    }

    public BannerPrice withOldPrice(BigDecimal oldPrice) {
        this.oldPrice = oldPrice;
        return this;
    }

    public String getPrefix() {
        return prefix;
    }

    public BannerPrice withPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public BannerPricesCurrency getCurrency() {
        return currency;
    }

    public BannerPrice withCurrency(BannerPricesCurrency currency) {
        this.currency = currency;
        return this;
    }
}
