package ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import com.google.gson.annotations.SerializedName;

import ru.yandex.autotests.directapi.darkside.model.multipliers.BsAtom;

/**
 * Отправляемые основным транспортом данные одной кампании
 * User: mexicano
 * Date: 14.08.14
 */
public class Campaign {
    //Количество знаков после запятой для отправки автобюджетных значений
    public static final int PRECISION_DIGIT_COUNT_RUB = 4;
    public static final int PRECISION_DIGIT_COUNT_YNDX_FIXED = 6;

    public static final String CONTEXTS = "CONTEXT";
    public static final String MOBILE_PRICE_COEF = "MobilePriceCoef";
    public static final String MOBILE_IOS_PRICE_COEF = "MobileIOSPriceCoef";
    public static final String MOBILE_ANDROID_PRICE_COEF = "MobileAndroidPriceCoef";
    public static final String DESKTOP_PRICE_COEF = "DesktopPriceCoef";
    public static final String SOCDEM_COEF = "SocdemCoef";
    public static final String RETARGETING_COEF = "RetargetingCoef";
    public static final String EXPRESSION_COEFS = "ExpressionCoefs";
    public static final String EXPRESSION_COEFS_WEATHER = "Weather";
    public static final String EXPRESSION_COEFS_SOCDEM = "Socdem";
    public static final String COUNTER_ID = "CounterID";
    public static final String AUTO_BUDGET_MAX_BID = "AutoBudgetMaxBid";
    public static final String AUTO_BUDGET_MAX_BID_CUR = "AutoBudgetMaxBidCur";
    public static final String AUTO_BUDGET_WEEK_LIMIT = "AutoBudgetWeekLimit";
    public static final String AUTO_BUDGET_WEEK_LIMIT_CUR = "AutoBudgetWeekLimitCur";
    public static final String AUTO_BUDGET_AVG_BID = "AutoBudgetAvgBid";
    public static final String AUTO_BUDGET_AVG_BID_CUR = "AutoBudgetAvgBidCur";
    public static final String AUTO_BUDGET_AVG_CPA = "AutoBudgetAvgCPA";
    public static final String AUTO_BUDGET_AVG_CPA_CUR = "AutoBudgetAvgCPACur";
    public static final String AUTO_BUDGET_DAY_LIMIT_MONEY_CUR = "AutoBudgetDayLimitMoneyCur";
    public static final String AUTO_BUDGET_DAY_LIMIT_MONEY = "AutoBudgetDayLimitMoney";
    public static final String REGION_COEF = "RegionCoef";
    public static final String ATTRIBUTION_TYPE = "AttributionType";
    public static final String PRODUCT_TYPE_COEF = "ProductTypeCoef";
    public static final String STAT_DIMENSIONS = "StatDimensions";
    public static final String TARGET_DIMENSIONS = "TargetDimensions";
    public static final String COEF_DIMENSIONS = "CoefDimensions";
    public static final String AUTO_BUDGET_GOAL_EXPRESSION = "AutoBudgetGoalExpression";
    public static final String TRAFARET_POSITION_BID_CORRECTION = "TrafaretPositionBidCorrections";
    public static final String AUTO_BUDGET_PROMOTIONS = "AutoBudgetPromotions";
    public static final String AUTO_BUDGET_DAY_WEIGHT = "AutoBudgetDayWeight";
    public static final String IS_CPD = "IsCPD";


    @SerializedName("EID")
    private String eid;

    @SerializedName("MaxCPC")
    private Integer maxCpc;

    @SerializedName("AutoBudget")
    private Integer autoBudget;

    @SerializedName("AutoOptimization")
    private Integer autoOptimization;

    @SerializedName("AutoBudgetROILevel")
    private Float autoBudgetROILevel;

    @SerializedName("AutoBudgetMaxBid")
    private Float autoBudgetMaxBid;

    @SerializedName("AutoBudgetMaxBidCur")
    private Float autoBudgetMaxBidCur;

    @SerializedName("AutoBudgetWeekLimit")
    private Float autoBudgetWeekLimit;

    @SerializedName("AutoBudgetWeekLimitCur")
    private Float autoBudgetWeekLimitCur;

    @SerializedName("AutoBudgetWeekLimitClicks")
    private Integer autoBudgetWeekLimitClicks;

    @SerializedName("AutoBudgetReserveReturn")
    private Float autoBudgetReserveReturn;

    @SerializedName("AutoBudgetProfitability")
    private Float autoBudgetProfitability;

    @SerializedName("AutoBudgetGoalID")
    private Integer autoBudgetGoalId;

    @SerializedName("AutoBudgetAvgBid")
    private Float autoBudgetAvgBid;

    @SerializedName("AutoBudgetAvgBidCur")
    private Float autoBudgetAvgBidCur;

    @SerializedName("AutoBudgetAvgCPA")
    private Float autoBudgetAvgCPA;

    @SerializedName("AutoBudgetAvgCPACur")
    private Float autoBudgetAvgCPACur;

    @SerializedName("AutoBudgetRegularSpent")
    private Integer autoBudgetRegularSpent;

    @SerializedName("AutoBudgetDayLimitMoneyCur")
    private Float autoBudgetDayLimitMoneyCur;

    @SerializedName("AutoBudgetDayLimitMoney")
    private Float autoBudgetDayLimitMoney;

    @SerializedName("AutoBudgetNetCPCOptimize")
    private Integer autoBudgetNetCPCOptimize;

    @SerializedName("ContextLimit")
    private String contextLimit;

    @SerializedName("ContextPriceCoef")
    private String contextPriceCoef;

    @SerializedName("AgencyID")
    private Integer agencyId;

    @SerializedName("StatusEasy")
    private Integer statusEasy;

    @SerializedName("SUMCur")
    private Double sumCur;

    @SerializedName("CompetitorsDomains")
    private CompetitorsDomains competitorsDomains;

    @SerializedName("Strategy")
    private String strategy;

    @SerializedName("OrderType")
    private Integer orderType;

    @SerializedName("Archive")
    private Integer archive;

    private String statusClickTrack;

    private String uid;

    private Integer statusNoBehav;

    @SerializedName("QueueSetTime")
    private String queueSetTime;

    @SerializedName("SUM")
    private Double sum;

    @SerializedName("ShowCondition")
    private ShowCondition showCondition;

    @SerializedName("UpdateInfo")
    private Integer updateInfo;

    @SerializedName("ClientID")
    private String clientID;

    @SerializedName("Stop")
    private Integer stop;

    @SerializedName("GroupOrderID")
    private Integer groupOrderID;

    @SerializedName("ID")
    private String id;

    @SerializedName("CurrencyISOCode")
    private Integer currencyIsoCode;

    @SerializedName("BlockFavicon")
    private Integer blockFavicon;

    @SerializedName("TimeTargetCoef")
    private String timeTargetCoef;

    @SerializedName("Start_time")
    private String startTime;

    @SerializedName("NDSHistory")
    private List<NdsHistoryElem> ndsHistory = new ArrayList<>();

    @SerializedName("DiscountHistory")
    private List<DiscountHistoryElem> discountHistory = new ArrayList<>();

    @SerializedName("GroupOrder")
    private Integer groupOrder;

    @SerializedName("IndependentBids")
    private Integer independentBids;

    @SerializedName("IsPriorityCampaign")
    private Integer isPriorityCampaign;

    @SerializedName("IgnoreTimeLimit")
    private String ignoreTimeLimit;

    @SerializedName("CurrencyConvertDate")
    private String currencyConvertDate;

    @SerializedName("ManagerUID")
    private Integer managerUid;

    private Integer statusOpenStat;

    private Integer statusYandexAdv;

    @SerializedName("Description")
    private String description;

    @SerializedName("CONTEXT")
    private Map<String, Context> contexts;

    @SerializedName("CostPcs")
    private Double costPcs;

    @SerializedName("MobilePriceCoef")
    private String mobilePriceCoef;

    @SerializedName(MOBILE_IOS_PRICE_COEF)
    private String mobileIOSPriceCoef;

    @SerializedName(MOBILE_ANDROID_PRICE_COEF)
    private String mobileAndroidPriceCoef;

    @SerializedName("DesktopPriceCoef")
    private String desktopPriceCoef;

    @SerializedName("RetargetingCoef")
    private Map<String, RetargetingCoef> retargetingCoef;

    @SerializedName("SocdemCoef")
    private SocdemCoef socdemCoef;

    @SerializedName("HideMarketRating")
    private Integer hideMarketRating;

    @SerializedName("CheckBannersAvailability")
    private Integer checkBannersAvailability; //1-0

    @SerializedName("CounterID")
    private Integer counterID;

    @SerializedName("ContentType")
    private String contentType;

    @SerializedName("statusNoExtendedGeotargeting")
    private Integer statusNoExtendedGeotargeting;

    @SerializedName("statusUseCurrentRegion")
    private Integer statusUseCurrentRegion;

    @SerializedName("statusUseRegularRegion")
    private Integer statusUseRegularRegion;

    @SerializedName("AllowAloneTrafaret")
    private Integer AllowAloneTrafaret;

    @SerializedName("RequireFiltrationByDontShowDomains")
    private Integer requireFiltrationByDontShowDomains;

    @SerializedName("Resources")
    private CampaignResources resources;

    @SerializedName("ExperimentOnPercentageOfUsers")
    private ExperimentData experimentOnPercentageOfUsers;

    @SerializedName(EXPRESSION_COEFS)
    private ExpressionCoefs expressionCoefs;

    @SerializedName("CountryRegionID")
    private Short countryRegionId;

    @SerializedName("AttributionType")
    private Integer attributionType; // 1-3

    @SerializedName(REGION_COEF)
    private Map<String, Integer> regionCoef;

    @SerializedName("MaxRF")
    private Integer maxRF;

    @SerializedName("RFDays")
    private Integer rfDays;

    @SerializedName("AutoBudgetOptimizeRF")
    private Integer autoBudgetOptimizeRF;

    @SerializedName("RFDecay")
    private Double rfDecay;

    @SerializedName("RFMinCPM")
    private Integer rfMinCPM;

    @SerializedName("AutoBudgetAvgCPM")
    private Float autoBudgetAvgCPM;

    @SerializedName("AutoBudgetAvgCPMCur")
    private Float autoBudgetAvgCPMCur;

    @SerializedName("AutoBudgetPeriodBudgetLimit")
    private Float autoBudgetPeriodBudgetLimit;

    @SerializedName("AutoBudgetPeriodBudgetLimitCur")
    private Float autoBudgetPeriodBudgetLimitCur;

    @SerializedName("AutoBudgetPeriodBudgetFinish")
    private String autoBudgetPeriodBudgetFinish;

    @SerializedName("AutoBudgetPeriodBudgetProlongation")
    private Integer autoBudgetPeriodBudgetProlongation;

    @SerializedName("AutoBudgetStrategy")
    private String autoBudgetStrategy;

    @SerializedName("AutoBudgetPaidActions")
    private Integer autobudgetPaidActions;

    @SerializedName("AutoBudgetPaidActionsPerFilter")
    private Integer autoBudgetPaidActionsPerFilter;

    @SerializedName("DirectDeals")
    private List<ItemDeal> directDeals;

    @SerializedName("AgencyCoef")
    private Integer agencyCoef;

    @SerializedName("PrivateDeal")
    private Integer privateDealFlag;

    @SerializedName("ProductTypeCoef")
    private ProductTypeCoef productTypeCoef;

    @SerializedName("isExtendedRelevanceMatchEnabled")
    private Integer isExtendedRelevanceMatchEnabled;

    @SerializedName("StatDimensions")
    private List<AbSegmentsDimension> statDimensions;

    @SerializedName("TargetDimensions")
    private List<AbSegmentsDimension> targetDimensions;

    @SerializedName("CoefDimensions")
    private List<CoefDimension> coefDimensions;

    @SerializedName("AutoBudgetGoalExpression")
    private String autoBudgetGoalExpression;

    @SerializedName("isVirtual")
    private Integer isVirtual;

    @SerializedName("BillingOrders")
    private BillingOrders billingOrders;

    @SerializedName("InventoryTypeCoef")
    private InventoryTypeCoef inventoryTypeCoef;

    @SerializedName("IsMobileApp")
    private Integer isMobileApp;

    @SerializedName("SKAdNetworkCampaignID")
    private Long skAdNetworkCampaignId;

    @SerializedName("S2STrackingURLs")
    private Map<String, String> s2sTrackingUrls;

    @SerializedName("RestrictionType")
    private String restrictionType;

    @SerializedName("RestrictionValue")
    private Long restrictionValue;

    @SerializedName("PageIDS")
    private List<String> pageIds;

    @SerializedName("PlaceID")
    private Long placeId;

    @SerializedName("ServiceName")
    private String serviceName;

    @SerializedName("RotationGoalID")
    private Long rotationGoalId;

    @SerializedName("RfCloseByClick")
    private String rfCloseByClick;

    @SerializedName("StrategyParams")
    private StrategyParams strategyParams;

    @SerializedName("AuctionPriority")
    private Integer auctionPriority;

    @SerializedName("IsFixPrice")
    private Integer isFixPrice;

    @SerializedName("TargetingExpression")
    private List<List<BsAtom>> targetingExpression;

    @SerializedName("ImpressionStandardTime")
    private Short impressionStandardTime;

    @SerializedName("ImpressionStandardType")
    private String impressionStandardType;

    @SerializedName("EshowsBannerRate")
    private BigDecimal eshowsBannerRate;

    @SerializedName("EshowsVideoRate")
    private BigDecimal eshowsVideoRate;

    @SerializedName("EshowsVideoType")
    private String eshowsVideoType;

    @SerializedName("SourceInterface")
    private String sourceInterface;

    @SerializedName("AutoBudgetPaidCrr")
    private Integer autoBudgetPaidCrr;

    @SerializedName("EnableOrderPhraseLengthPrecedence")
    private String enableOrderPhraseLengthPrecedence;

    @SerializedName("MeaningfulGoals")
    private List<MeaningfulGoal> meaningfulGoals;

    @SerializedName("AutoBudgetPaidMeaningfulGoalsHash")
    private String meaningfulGoalsHash;

    @SerializedName(TRAFARET_POSITION_BID_CORRECTION)
    private Map<String, Double> trafaretPositionBidCorrections;

    @SerializedName("MetrikaCountersHash")
    private String metrikaCountersHash;

    @SerializedName("StrategyID")
    private Long strategyId;

    @SerializedName(AUTO_BUDGET_PROMOTIONS)
    private List<AutoBudgetPromotion> autoBudgetPromotions;

    @SerializedName(AUTO_BUDGET_DAY_WEIGHT)
    private Long autoBudgetDayWeight;

    @SerializedName(IS_CPD)
    private Integer isCPD;

    public StrategyParams getStrategyParams() {
        return strategyParams;
    }

    public void setStrategyParams(StrategyParams strategyParams) {
        this.strategyParams = strategyParams;
    }

    public List<ItemDeal> getDirectDeals() {
        return directDeals;
    }

    public void setDirectDeals(
            List<ItemDeal> directDeals) {
        this.directDeals = directDeals;
    }

    public Integer getAgencyCoef() {
        return agencyCoef;
    }

    public void setAgencyCoef(Integer agencyCoef) {
        this.agencyCoef = agencyCoef;
    }

    public Integer getPrivateDealFlag() {
        return privateDealFlag;
    }

    public void setPrivateDealFlag(Integer privateDealFlag) {
        this.privateDealFlag = privateDealFlag;
    }

    //    ProductID????

    public Context getContext(Long pid) {
        if (contexts == null) {
            return null;
        }
        for (Map.Entry<String, Context> entry : contexts.entrySet()) {
            if (entry.getValue().getEid().equals("" + pid)) {
                return entry.getValue();
            }
        }
        return null;
    }

    public Integer getAttributionType() {
        return attributionType;
    }

    public void setAttributionType(Integer attributionType) {
        this.attributionType = attributionType;
    }

    public String getEid() {
        return eid;
    }

    public void setEid(String eid) {
        this.eid = eid;
    }

    public Integer getMaxCpc() {
        return maxCpc;
    }

    public void setMaxCpc(Integer maxCpc) {
        this.maxCpc = maxCpc;
    }

    public Integer getAutoBudget() {
        return autoBudget;
    }

    public void setAutoBudget(Integer autoBudget) {
        this.autoBudget = autoBudget;
    }

    public Integer getAutoOptimization() {
        return autoOptimization;
    }

    public void setAutoOptimization(Integer autoOptimization) {
        this.autoOptimization = autoOptimization;
    }

    public Float getAutoBudgetROILevel() {
        return autoBudgetROILevel;
    }

    public void setAutoBudgetROILevel(Float autoBudgetROILevel) {
        this.autoBudgetROILevel = autoBudgetROILevel;
    }

    public Float getAutoBudgetMaxBid() {
        return autoBudgetMaxBid;
    }

    public void setAutoBudgetMaxBid(Float autoBudgetMaxBid) {
        this.autoBudgetMaxBid = autoBudgetMaxBid;
    }

    public Float getAutoBudgetMaxBidCur() {
        return autoBudgetMaxBidCur;
    }

    public void setAutoBudgetMaxBidCur(Float autoBudgetMaxBidCur) {
        this.autoBudgetMaxBidCur = autoBudgetMaxBidCur;
    }

    public Float getAutoBudgetWeekLimit() {
        return autoBudgetWeekLimit;
    }

    public void setAutoBudgetWeekLimit(Float autoBudgetWeekLimit) {
        this.autoBudgetWeekLimit = autoBudgetWeekLimit;
    }

    public Float getAutoBudgetWeekLimitCur() {
        return autoBudgetWeekLimitCur;
    }

    public void setAutoBudgetWeekLimitCur(Float autoBudgetWeekLimitCur) {
        this.autoBudgetWeekLimitCur = autoBudgetWeekLimitCur;
    }

    public Integer getAutoBudgetWeekLimitClicks() {
        return autoBudgetWeekLimitClicks;
    }

    public void setAutoBudgetWeekLimitClicks(Integer autoBudgetWeekLimitClicks) {
        this.autoBudgetWeekLimitClicks = autoBudgetWeekLimitClicks;
    }

    public Float getAutoBudgetReserveReturn() {
        return autoBudgetReserveReturn;
    }

    public void setAutoBudgetReserveReturn(Float autoBudgetReserveReturn) {
        this.autoBudgetReserveReturn = autoBudgetReserveReturn;
    }

    public Float getAutoBudgetProfitability() {
        return autoBudgetProfitability;
    }

    public void setAutoBudgetProfitability(Float autoBudgetProfitability) {
        this.autoBudgetProfitability = autoBudgetProfitability;
    }

    public Integer getAutoBudgetGoalId() {
        return autoBudgetGoalId;
    }

    public void setAutoBudgetGoalId(Integer autoBudgetGoalId) {
        this.autoBudgetGoalId = autoBudgetGoalId;
    }

    public Float getAutoBudgetAvgBid() {
        return autoBudgetAvgBid;
    }

    public void setAutoBudgetAvgBid(Float autoBudgetAvgBid) {
        this.autoBudgetAvgBid = autoBudgetAvgBid;
    }

    public Float getAutoBudgetAvgBidCur() {
        return autoBudgetAvgBidCur;
    }

    public void setAutoBudgetAvgBidCur(Float autoBudgetAvgBidCur) {
        this.autoBudgetAvgBidCur = autoBudgetAvgBidCur;
    }

    public Float getAutoBudgetAvgCPA() {
        return autoBudgetAvgCPA;
    }

    public void setAutoBudgetAvgCPA(Float autoBudgetAvgCPA) {
        this.autoBudgetAvgCPA = autoBudgetAvgCPA;
    }

    public Float getAutoBudgetAvgCPACur() {
        return autoBudgetAvgCPACur;
    }

    public void setAutoBudgetAvgCPACur(Float autoBudgetAvgCPACur) {
        this.autoBudgetAvgCPACur = autoBudgetAvgCPACur;
    }

    public Integer getAutoBudgetRegularSpent() {
        return autoBudgetRegularSpent;
    }

    public void setAutoBudgetRegularSpent(Integer autoBudgetRegularSpent) {
        this.autoBudgetRegularSpent = autoBudgetRegularSpent;
    }

    public Float getAutoBudgetDayLimitMoneyCur() {
        return autoBudgetDayLimitMoneyCur;
    }

    public void setAutoBudgetDayLimitMoneyCur(Float autoBudgetDayLimitMoneyCur) {
        this.autoBudgetDayLimitMoneyCur = autoBudgetDayLimitMoneyCur;
    }

    public Float getAutoBudgetDayLimitMoney() {
        return autoBudgetDayLimitMoney;
    }

    public void setAutoBudgetDayLimitMoney(Float autoBudgetDayLimitMoney) {
        this.autoBudgetDayLimitMoney = autoBudgetDayLimitMoney;
    }

    public String getAutoBudgetStrategy() {
        return autoBudgetStrategy;
    }

    public void setAutoBudgetStrategy(String autoBudgetStrategy) {
        this.autoBudgetStrategy = autoBudgetStrategy;
    }

    public String getContextLimit() {
        return contextLimit;
    }

    public void setContextLimit(String contextLimit) {
        this.contextLimit = contextLimit;
    }

    public String getContextPriceCoef() {
        return contextPriceCoef;
    }

    public void setContextPriceCoef(String contextPriceCoef) {
        this.contextPriceCoef = contextPriceCoef;
    }

    public Integer getAgencyId() {
        return agencyId;
    }

    public void setAgencyId(Integer agencyId) {
        this.agencyId = agencyId;
    }

    public Integer getStatusEasy() {
        return statusEasy;
    }

    public void setStatusEasy(Integer statusEasy) {
        this.statusEasy = statusEasy;
    }

    public Double getSumCur() {
        return sumCur;
    }

    public void setSumCur(Double sumCur) {
        this.sumCur = sumCur;
    }

    public CompetitorsDomains getCompetitorsDomains() {
        return competitorsDomains;
    }

    public void setCompetitorsDomains(CompetitorsDomains competitorsDomains) {
        this.competitorsDomains = competitorsDomains;
    }

    public String getStrategy() {
        return strategy;
    }

    public void setStrategy(String strategy) {
        this.strategy = strategy;
    }

    public Integer getOrderType() {
        return orderType;
    }

    public void setOrderType(Integer orderType) {
        this.orderType = orderType;
    }

    public Integer getArchive() {
        return archive;
    }

    public void setArchive(Integer archive) {
        this.archive = archive;
    }

    public String getStatusClickTrack() {
        return statusClickTrack;
    }

    public void setStatusClickTrack(String statusClickTrack) {
        this.statusClickTrack = statusClickTrack;
    }

    public String getUid() {
        return uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public Integer getStatusNoBehav() {
        return statusNoBehav;
    }

    public void setStatusNoBehav(Integer statusNoBehav) {
        this.statusNoBehav = statusNoBehav;
    }

    public String getQueueSetTime() {
        return queueSetTime;
    }

    public void setQueueSetTime(String queueSetTime) {
        this.queueSetTime = queueSetTime;
    }

    public Double getSum() {
        return sum;
    }

    public void setSum(Double sum) {
        this.sum = sum;
    }

    public ShowCondition getShowCondition() {
        return showCondition;
    }

    public void setShowCondition(ShowCondition showCondition) {
        this.showCondition = showCondition;
    }

    public Integer getUpdateInfo() {
        return updateInfo;
    }

    public void setUpdateInfo(Integer updateInfo) {
        this.updateInfo = updateInfo;
    }

    public String getClientID() {
        return clientID;
    }

    public void setClientID(String clientID) {
        this.clientID = clientID;
    }

    public Integer getStop() {
        return stop;
    }

    public void setStop(Integer stop) {
        this.stop = stop;
    }

    public Integer getGroupOrderID() {
        return groupOrderID;
    }

    public void setGroupOrderID(Integer groupOrderID) {
        this.groupOrderID = groupOrderID;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Integer getCurrencyIsoCode() {
        return currencyIsoCode;
    }

    public void setCurrencyIsoCode(Integer currencyIsoCode) {
        this.currencyIsoCode = currencyIsoCode;
    }

    public Integer getBlockFavicon() {
        return blockFavicon;
    }

    public void setBlockFavicon(Integer blockFavicon) {
        this.blockFavicon = blockFavicon;
    }

    public String getTimeTargetCoef() {
        return timeTargetCoef;
    }

    public void setTimeTargetCoef(String timeTargetCoef) {
        this.timeTargetCoef = timeTargetCoef;
    }

    public String getStartTime() {
        return startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public List<NdsHistoryElem> getNdsHistory() {
        return ndsHistory;
    }

    public void setNdsHistory(List<NdsHistoryElem> ndsHistory) {
        this.ndsHistory = ndsHistory;
    }

    public List<DiscountHistoryElem> getDiscountHistory() {
        return discountHistory;
    }

    public void setDiscountHistory(List<DiscountHistoryElem> discountHistory) {
        this.discountHistory = discountHistory;
    }

    public Integer getGroupOrder() {
        return groupOrder;
    }

    public void setGroupOrder(Integer groupOrder) {
        this.groupOrder = groupOrder;
    }

    public Integer getIndependentBids() {
        return independentBids;
    }

    public void setIndependentBids(Integer independentBids) {
        this.independentBids = independentBids;
    }

    public Integer getIsPriorityCampaign() {
        return isPriorityCampaign;
    }

    public void setIsPriorityCampaign(Integer isPriorityCampaign) {
        this.isPriorityCampaign = isPriorityCampaign;
    }

    public String getCurrencyConvertDate() {
        return currencyConvertDate;
    }

    public void setCurrencyConvertDate(String currencyConvertDate) {
        this.currencyConvertDate = currencyConvertDate;
    }

    public Integer getManagerUid() {
        return managerUid;
    }

    public void setManagerUid(Integer managerUid) {
        this.managerUid = managerUid;
    }

    public Integer getStatusOpenStat() {
        return statusOpenStat;
    }

    public void setStatusOpenStat(Integer statusOpenStat) {
        this.statusOpenStat = statusOpenStat;
    }

    public Integer getStatusYandexAdv() {
        return statusYandexAdv;
    }

    public void setStatusYandexAdv(Integer statusYandexAdv) {
        this.statusYandexAdv = statusYandexAdv;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Map<String, Context> getContexts() {
        return contexts;
    }

    public void setContexts(Map<String, Context> contexts) {
        this.contexts = contexts;
    }

    public Double getCostPcs() {
        return costPcs;
    }

    public void setCostPcs(Double costPcs) {
        this.costPcs = costPcs;
    }

    public String getMobilePriceCoef() {
        return mobilePriceCoef;
    }

    public void setMobilePriceCoef(String mobilePriceCoef) {
        this.mobilePriceCoef = mobilePriceCoef;
    }

    public String getMobileIOSPriceCoef() {
        return mobileIOSPriceCoef;
    }

    public Campaign setMobileIOSPriceCoef(String mobileIOSPriceCoef) {
        this.mobileIOSPriceCoef = mobileIOSPriceCoef;
        return this;
    }

    public String getMobileAndroidPriceCoef() {
        return mobileAndroidPriceCoef;
    }

    public Campaign setMobileAndroidPriceCoef(String mobileAndroidPriceCoef) {
        this.mobileAndroidPriceCoef = mobileAndroidPriceCoef;
        return this;
    }

    public String getDesktopPriceCoef() {
        return desktopPriceCoef;
    }

    public Campaign setDesktopPriceCoef(String desktopPriceCoef) {
        this.desktopPriceCoef = desktopPriceCoef;
        return this;
    }

    public Map<String, RetargetingCoef> getRetargetingCoef() {
        return retargetingCoef;
    }

    public void setRetargetingCoef(Map<String, RetargetingCoef> retargetingCoef) {
        this.retargetingCoef = retargetingCoef;
    }

    public SocdemCoef getSocdemCoef() {
        return socdemCoef;
    }

    public void setSocdemCoef(SocdemCoef socdemCoef) {
        this.socdemCoef = socdemCoef;
    }

    public Integer getHideMarketRating() {
        return hideMarketRating;
    }

    public void setHideMarketRating(Integer hideMarketRating) {
        this.hideMarketRating = hideMarketRating;
    }

    public Integer getAutoBudgetNetCPCOptimize() {
        return autoBudgetNetCPCOptimize;
    }

    public void setAutoBudgetNetCPCOptimize(Integer autoBudgetNetCPCOptimize) {
        this.autoBudgetNetCPCOptimize = autoBudgetNetCPCOptimize;
    }

    public Integer getCounterID() {
        return counterID;
    }

    public void setCounterID(Integer counterID) {
        this.counterID = counterID;
    }

    public Integer getCheckBannersAvailability() {
        return checkBannersAvailability;
    }

    public void setCheckBannersAvailability(Integer checkBannersAvailability) {
        this.checkBannersAvailability = checkBannersAvailability;
    }

    public String getContentType() {
        return contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public Integer getStatusNoExtendedGeotargeting() {
        return statusNoExtendedGeotargeting;
    }

    public void setStatusNoExtendedGeotargeting(Integer statusNoExtendedGeotargeting) {
        this.statusNoExtendedGeotargeting = statusNoExtendedGeotargeting;
    }

    public Integer getStatusUseCurrentRegion() {
        return statusUseCurrentRegion;
    }

    public void setStatusUseCurrentRegion(Integer statusUseCurrentRegion) {
        this.statusUseCurrentRegion = statusUseCurrentRegion;
    }

    public Integer getStatusUseRegularRegion() {
        return statusUseRegularRegion;
    }

    public void setStatusUseRegularRegion(Integer statusUseRegularRegion) {
        this.statusUseRegularRegion = statusUseRegularRegion;
    }

    public Integer getAllowAloneTrafaret() {
        return AllowAloneTrafaret;
    }

    public void setAllowAloneTrafaret(Integer allowAloneTrafaret) {
        AllowAloneTrafaret = allowAloneTrafaret;
    }

    public Integer getRequireFiltrationByDontShowDomains() {
        return requireFiltrationByDontShowDomains;
    }

    public void setRequireFiltrationByDontShowDomains(Integer requireFiltrationByDontShowDomains) {
        requireFiltrationByDontShowDomains = requireFiltrationByDontShowDomains;
    }

    public String getIgnoreTimeLimit() {
        return ignoreTimeLimit;
    }

    public void setIgnoreTimeLimit(String ignoreTimeLimit) {
        this.ignoreTimeLimit = ignoreTimeLimit;
    }

    public ExperimentData getExperimentOnPercentageOfUsers() {
        return experimentOnPercentageOfUsers;
    }

    public Short getCountryRegionId() {
        return countryRegionId;
    }

    public void setExperimentOnPercentageOfUsers(ExperimentData experimentOnPercentageOfUsers) {
        this.experimentOnPercentageOfUsers = experimentOnPercentageOfUsers;
    }

    public void setCountryRegionId(Short countryRegionId) {
        this.countryRegionId = countryRegionId;
    }

    public CampaignResources getResources() {
        return resources;
    }

    public void setResources(CampaignResources resources) {
        this.resources = resources;
    }

    public Map<String, Integer> getRegionCoef() {
        return regionCoef;
    }

    public void setRegionCoef(Map<String, Integer> regionCoef) {
        this.regionCoef = regionCoef;
    }

    public Integer getMaxRF() {
        return maxRF;
    }

    public void setMaxRF(Integer maxRF) {
        this.maxRF = maxRF;
    }

    public Integer getRfDays() {
        return rfDays;
    }

    public void setRfDays(Integer rfDays) {
        this.rfDays = rfDays;
    }

    public Integer getAutoBudgetOptimizeRF() {
        return autoBudgetOptimizeRF;
    }

    public void setAutoBudgetOptimizeRF(Integer autoBudgetOptimizeRF) {
        this.autoBudgetOptimizeRF = autoBudgetOptimizeRF;
    }

    public Double getRfDecay() {
        return rfDecay;
    }

    public void setRfDecay(Double rfDecay) {
        this.rfDecay = rfDecay;
    }

    public Integer getRfMinCPM() {
        return rfMinCPM;
    }

    public void setRfMinCPM(Integer rfMinCPM) {
        this.rfMinCPM = rfMinCPM;
    }

    public Float getAutoBudgetAvgCPM() {
        return autoBudgetAvgCPM;
    }

    public void setAutoBudgetAvgCPM(Float autoBudgetAvgCPM) {
        this.autoBudgetAvgCPM = autoBudgetAvgCPM;
    }

    public Float getAutoBudgetAvgCPMCur() {
        return autoBudgetAvgCPMCur;
    }

    public void setAutoBudgetAvgCPMCur(Float autoBudgetAvgCPMCur) {
        this.autoBudgetAvgCPMCur = autoBudgetAvgCPMCur;
    }

    public Float getAutoBudgetPeriodBudgetLimit() {
        return autoBudgetPeriodBudgetLimit;
    }

    public void setAutoBudgetPeriodBudgetLimit(Float autoBudgetPeriodBudgetLimit) {
        this.autoBudgetPeriodBudgetLimit = autoBudgetPeriodBudgetLimit;
    }

    public Float getAutoBudgetPeriodBudgetLimitCur() {
        return autoBudgetPeriodBudgetLimitCur;
    }

    public void setAutoBudgetPeriodBudgetLimitCur(Float autoBudgetPeriodBudgetLimitCur) {
        this.autoBudgetPeriodBudgetLimitCur = autoBudgetPeriodBudgetLimitCur;
    }

    public String getAutoBudgetPeriodBudgetFinish() {
        return autoBudgetPeriodBudgetFinish;
    }

    public void setAutoBudgetPeriodBudgetFinish(String autoBudgetPeriodBudgetFinish) {
        this.autoBudgetPeriodBudgetFinish = autoBudgetPeriodBudgetFinish;
    }

    public Integer getAutoBudgetPeriodBudgetProlongation() {
        return autoBudgetPeriodBudgetProlongation;
    }

    public void setAutoBudgetPeriodBudgetProlongation(Integer autoBudgetPeriodBudgetProlongation) {
        this.autoBudgetPeriodBudgetProlongation = autoBudgetPeriodBudgetProlongation;
    }

    public Integer getAutobudgetPaidActions() {
        return autobudgetPaidActions;
    }

    public void setAutobudgetPaidActions(Integer autobudgetPaidActions) {
        this.autobudgetPaidActions = autobudgetPaidActions;
    }

    public Integer getAutoBudgetPaidActionsPerFilter() {
        return autoBudgetPaidActionsPerFilter;
    }

    public void setAutoBudgetPaidActionsPerFilter(Integer autoBudgetPaidActionsPerFilter) {
        this.autoBudgetPaidActionsPerFilter = autoBudgetPaidActionsPerFilter;
    }

    public ProductTypeCoef getProductTypeCoef() {
        return productTypeCoef;
    }

    public void setProductTypeCoef(ProductTypeCoef productTypeCoef) {
        this.productTypeCoef = productTypeCoef;
    }

    public Integer getIsExtendedRelevanceMatchEnabled() {
        return isExtendedRelevanceMatchEnabled;
    }

    public void setIsExtendedRelevanceMatchEnabled(Integer isExtendedRelevanceMatchEnabled) {
        this.isExtendedRelevanceMatchEnabled = isExtendedRelevanceMatchEnabled;
    }

    public List<AbSegmentsDimension> getStatDimensions() {
        return statDimensions;
    }

    public void setStatDimensions(List<AbSegmentsDimension> statDimensions) {
        this.statDimensions = statDimensions;
    }

    public List<AbSegmentsDimension> getTargetDimensions() {
        return targetDimensions;
    }

    public void setTargetDimensions(List<AbSegmentsDimension> targetDimensions) {
        this.targetDimensions = targetDimensions;
    }

    public List<CoefDimension> getCoefDimensions() {
        return coefDimensions;
    }

    public void setCoefDimensions(List<CoefDimension> coefDimensions) {
        this.coefDimensions = coefDimensions;
    }

    public String getAutoBudgetGoalExpression() {
        return autoBudgetGoalExpression;
    }

    public void setAutoBudgetGoalExpression(String autoBudgetGoalExpression) {
        this.autoBudgetGoalExpression = autoBudgetGoalExpression;
    }

    public Integer getIsVirtual() {
        return isVirtual;
    }

    public void setIsVirtual(Integer isVirtual) {
        this.isVirtual = isVirtual;
    }

    public BillingOrders getBillingOrders() {
        return billingOrders;
    }

    public void setBillingOrders(BillingOrders billingOrders) {
        this.billingOrders = billingOrders;
    }

    public InventoryTypeCoef getInventoryTypeCoef() {
        return inventoryTypeCoef;
    }

    public void setInventoryTypeCoef(InventoryTypeCoef inventoryTypeCoef) {
        this.inventoryTypeCoef = inventoryTypeCoef;
    }

    public ExpressionCoefs getExpressionCoefs() {
        return expressionCoefs;
    }

    public void setExpressionCoefs(ExpressionCoefs expressionCoefs) {
        this.expressionCoefs = expressionCoefs;
    }

    public Integer getIsMobileApp() {
        return isMobileApp;
    }

    public void setIsMobileApp(Integer isMobileApp) {
        this.isMobileApp = isMobileApp;
    }

    public String getRestrictionType() {
        return restrictionType;
    }

    public void setRestrictionType(String restrictionType) {
        this.restrictionType = restrictionType;
    }

    public Long getRestrictionValue() {
        return restrictionValue;
    }

    public void setRestrictionValue(Long restrictionValue) {
        this.restrictionValue = restrictionValue;
    }

    public List<String> getPageIds() {
        return pageIds;
    }

    public void setPageIds(List<String> pageIds) {
        this.pageIds = pageIds;
    }

    public Long getPlaceId() {
        return placeId;
    }

    public void setPlaceId(Long placeId) {
        this.placeId = placeId;
    }

    public String getServiceName() {
        return serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public Integer getAuctionPriority() {
        return auctionPriority;
    }

    public void setAuctionPriority(Integer auctionPriority) {
        this.auctionPriority = auctionPriority;
    }

    public Integer getIsFixPrice() {
        return isFixPrice;
    }

    public void setIsFixPrice(Integer isFixPrice) {
        this.isFixPrice = isFixPrice;
    }

    public Long getRotationGoalId() {
        return rotationGoalId;
    }

    public void setRotationGoalId(Long rotationGoalId) {
        this.rotationGoalId = rotationGoalId;
    }

    public String getRfCloseByClick() {
        return rfCloseByClick;
    }

    public void setRfCloseByClick(String rfCloseByClick) {
        this.rfCloseByClick = rfCloseByClick;
    }

    public List<List<BsAtom>> getTargetingExpression() {
        return targetingExpression;
    }

    public void setTargetingExpression(List<List<BsAtom>> targetingExpression) {
        this.targetingExpression = targetingExpression;
    }

    public Short getImpressionStandardTime() {
        return impressionStandardTime;
    }

    public void setImpressionStandardTime(Short impressionStandardTime) {
        this.impressionStandardTime = impressionStandardTime;
    }

    public String getImpressionStandardType() {
        return impressionStandardType;
    }

    public void setImpressionStandardType(String impressionStandardType) {
        this.impressionStandardType = impressionStandardType;
    }

    public BigDecimal getEshowsBannerRate() {
        return eshowsBannerRate;
    }

    public void setEshowsBannerRate(BigDecimal eshowsBannerRate) {
        this.eshowsBannerRate = eshowsBannerRate;
    }

    public BigDecimal getEshowsVideoRate() {
        return eshowsVideoRate;
    }

    public void setEshowsVideoRate(BigDecimal eshowsVideoRate) {
        this.eshowsVideoRate = eshowsVideoRate;
    }

    public String getEshowsVideoType() {
        return eshowsVideoType;
    }

    public void setEshowsVideoType(String eshowsVideoType) {
        this.eshowsVideoType = eshowsVideoType;
    }

    public String getSourceInterface() {
        return sourceInterface;
    }

    public void setSourceInterface(String sourceInterface) {
        this.sourceInterface = sourceInterface;
    }

    public String getEnableOrderPhraseLengthPrecedence() {
        return enableOrderPhraseLengthPrecedence;
    }

    public void setEnableOrderPhraseLengthPrecedence(String enableOrderPhraseLengthPrecedence) {
        this.enableOrderPhraseLengthPrecedence = enableOrderPhraseLengthPrecedence;
    }

    public Integer getAutoBudgetPaidCrr() {
        return autoBudgetPaidCrr;
    }

    public void setAutoBudgetPaidCrr(Integer autoBudgetPaidCrr) {
        this.autoBudgetPaidCrr = autoBudgetPaidCrr;
    }

    public Long getSkAdNetworkCampaignId() {
        return skAdNetworkCampaignId;
    }

    public void setSkAdNetworkCampaignId(Long skAdNetworkCampaignId) {
        this.skAdNetworkCampaignId = skAdNetworkCampaignId;
    }

    public Map<String, String> getS2sTrackingUrls() {
        return s2sTrackingUrls;
    }

    public void setS2sTrackingUrls(Map<String, String> s2sTrackingUrls) {
        this.s2sTrackingUrls = s2sTrackingUrls;
    }

    public List<MeaningfulGoal> getMeaningfulGoals() {
        return meaningfulGoals;
    }

    public void setMeaningfulGoals(List<MeaningfulGoal> meaningfulGoals) {
        this.meaningfulGoals = meaningfulGoals;
    }

    public String getMeaningfulGoalsHash() {
        return meaningfulGoalsHash;
    }

    public void setMeaningfulGoalsHash(String meaningfulGoalsHash) {
        this.meaningfulGoalsHash = meaningfulGoalsHash;
    }

    public Map<String, Double> getTrafaretPositionBidCorrections() {
        return trafaretPositionBidCorrections;
    }

    public void setTrafaretPositionBidCorrections(Map<String, Double> trafaretPositionBidCorrections) {
        this.trafaretPositionBidCorrections = trafaretPositionBidCorrections;
    }

    public String getMetrikaCountersHash() {
        return metrikaCountersHash;
    }

    public void setMetrikaCountersHash(String metrikaCountersHash) {
        this.metrikaCountersHash = metrikaCountersHash;
    }

    public List<AutoBudgetPromotion> getAutoBudgetPromotions() {
        return autoBudgetPromotions;
    }

    public void setAutoBudgetPromotions(List<AutoBudgetPromotion> autoBudgetPromotions) {
        this.autoBudgetPromotions = autoBudgetPromotions;
    }

    public Long getAutoBudgetDayWeight() {
        return autoBudgetDayWeight;
    }

    public void setAutoBudgetDayWeight(Long autoBudgetDayWeight) {
        this.autoBudgetDayWeight = autoBudgetDayWeight;
    }

    public Long getStrategyId() {
        return strategyId;
    }

    public void setStrategyId(Long strategyId) {
        this.strategyId = strategyId;
    }

    public Integer getIsCPD() {
        return isCPD;
    }

    public void setIsCPD(Integer isCPD) {
        this.isCPD = isCPD;
    }
}
