package ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;

import ru.yandex.autotests.irt.testutils.json.JsonUtils;

/**
 * Запись в логе о передаче очередью stdprice
 * User: mexicano
 * Date: 14.08.14
 */
public class ClientDataStdpriceLogEntry {

    public static final String REQUEST = "request";
    public static final String RESPONSE = "response";

    private Map<String, Map<String, Object>> request;

    public Price getPrice(Long cid, Long pid, Long bidsId) {
        if (request == null) {
            return null;
        }

        Map<String, Object> campaign = request.get(Long.toString(cid));
        if (campaign == null) {
            return null;
        }

        Price[] prices = (Price[]) JsonUtils.convertTo(campaign.get(Long.toString(pid)), Price[].class);
        if (prices == null) {
            return null;
        }

        for (Price price : prices) {
            if (Long.toString(bidsId).equals(price.getId())) {
                return price;
            }
        }
        return null;
    }

    /**
     * Найти фактическую ставку динамического условия в логах отправки БК
     * @param cid id кампании
     * @param pid id группы
     * @param dynCondId id динамического условия как в dynamic_conditions
     * @return ставка динамического условия
     */
    public DynamicPrice getDynamicPrice(Long cid, Long pid, Long dynCondId) {
        if (request == null) {
            return null;
        }

        Map<String, Object> campaign = request.get(Long.toString(cid));
        if (campaign == null) {
            return null;
        }

        ArrayList<DynamicPrice> prices = new ArrayList<>(Arrays.asList((DynamicPrice[])
                        JsonUtils.convertTo(campaign.get(Long.toString(pid)), DynamicPrice[].class)));
        Optional<DynamicPrice>
                dynamicPriceOptional = prices.stream().filter(dynamicPrice -> dynamicPrice.getDynamicConditionId()
                .equals(Long.toString(dynCondId))).findFirst();
        return dynamicPriceOptional.orElse(null);
    }

    public Filter getFilter(Long cid, Long pid, Long perfFilterId) {
        if (request == null) {
            return null;
        }

        Map<String, Object> campaign = request.get(Long.toString(cid));
        if (campaign == null) {
            return null;
        }

        Filter[] filters = (Filter[]) JsonUtils.convertTo(campaign.get(Long.toString(pid)), Filter[].class);
        if (filters == null) {
            return null;
        }

        for (Filter filter : filters) {
            if (filter.getFilterEid().equals(Long.toString(perfFilterId))) {
                return filter;
            }
        }
        return null;
    }

    public RelevantMatchPrice getRelevanceMatch(Long cid, Long pid, Long bidId) {
        if (request == null) {
            return null;
        }

        Map<String, Object> campaign = request.get(Long.toString(cid));
        if (campaign == null) {
            return null;
        }

        RelevantMatchPrice[] relevantMatchPrices = (RelevantMatchPrice[]) JsonUtils
                .convertTo(campaign.get(Long.toString(pid)), RelevantMatchPrice[].class);
        if (relevantMatchPrices == null) {
            return null;
        }

        for (RelevantMatchPrice relevantMatchPrice : relevantMatchPrices) {
            if (relevantMatchPrice.getRelevanceMatchId() != null && relevantMatchPrice.getRelevanceMatchId()
                    .equals(bidId))
            {
                return relevantMatchPrice;
            }
        }
        return null;
    }

    public Price getRetargetingPriceContext(Long cid, Long pid, Long retId) {
        if (request == null) {
            return null;
        }

        Map<String, Object> campaign = request.get(Long.toString(cid));
        if (campaign == null) {
            return null;
        }

        Price[] prices = (Price[]) JsonUtils.convertTo(campaign.get(Long.toString(pid)), Price[].class);
        if (prices == null) {
            return null;
        }

        for (Price price : prices) {
            if (price.getRetId().equals(Long.toString(retId))) {
                return price;
            }
        }
        return null;
    }
}
