package ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import javax.annotation.Nullable;

import com.google.gson.annotations.SerializedName;

import ru.yandex.autotests.directapi.darkside.model.multipliers.BsAtom;

public class Context {

    public static final String BANNERS = "BANNER";
    public static final String FILTERS = "FILTER";
    public static final String MOBILE_PRICE_COEF = "MobilePriceCoef";
    public static final String MOBILE_IOS_PRICE_COEF = "MobileIOSPriceCoef";
    public static final String MOBILE_ANDROID_PRICE_COEF = "MobileAndroidPriceCoef";
    public static final String DESKTOP_PRICE_COEF = "DesktopPriceCoef";
    public static final String SOCDEM_COEF = "SocdemCoef";
    public static final String RETARGETING_COEF = "RetargetingCoef";
    public static final String PRODUCT_TYPE_COEF = "ProductTypeCoef";
    public static final String EXPRESSION_COEFS = "ExpressionCoefs";
    public static final String PHRASES = "PHRASE";
    public static final String DYNAMICS = "DYNAMIC";

    public static String phraseKey(Long id, Long phraseID) {
        String phraseIdStr = phraseID != null ? Long.toString(phraseID) : "0";
        return "P_" + phraseIdStr + "_" + id;
    }

    @SerializedName("ID")
    private String id;

    @SerializedName("EID")
    private String eid;

    @SerializedName("PHRASE")
    private Map<String, Phrase> phrases;

    @SerializedName("DYNAMIC")
    private Map<String, Dynamic> dynamics;

    @SerializedName("GOAL_CONTEXT")
    private Map<String, GoalContext> goalContexts;

    @SerializedName(BANNERS)
    private Map<String, Banner> banners;

    @SerializedName("MinusPhrases")
    private List<String> minusPhrases;

    @SerializedName("UpdateInfo")
    private Integer updateInfo;

    @SerializedName("Geo")
    private List<String> geo = new ArrayList<>();

    @SerializedName("MobilePriceCoef")
    private String mobilePriceCoef;

    @SerializedName(MOBILE_IOS_PRICE_COEF)
    private String mobileIOSPriceCoef;

    @SerializedName(MOBILE_ANDROID_PRICE_COEF)
    private String mobileAndroidPriceCoef;

    @SerializedName(DESKTOP_PRICE_COEF)
    private String desktopPriceCoef;

    @SerializedName("RetargetingCoef")
    private Map<String, RetargetingCoef> retargetingCoef;

    @SerializedName("SocdemCoef")
    private SocdemCoef socdemCoef;

    @SerializedName(EXPRESSION_COEFS)
    private ExpressionCoefs expressionCoefs;

    @SerializedName("Type")
    private String type;

    @SerializedName("MobileOSMinVersion")
    private Integer mobileOSMinVersion;

    @SerializedName("NetworkTargeting")
    private ContextNetworkTargeting networkTargeting;

    @SerializedName("DeviceTypeTargeting")
    private ContextDeviceTypeTargeting deviceTypeTargeting;

    @SerializedName("Resources")
    private Resources resources;

    @SerializedName("ContentOSType")
    private String contentOSType;

    @SerializedName("ContentStoreName")
    private String contentStoreName;

    @SerializedName("ContentStoreAppID")
    private String contentStoreAppID;

    @SerializedName("DontShow")
    private List<Integer> dontShow;

    @SerializedName(FILTERS)
    private Map<String, Filter> filters;

    @SerializedName("RELEVANCE_MATCH")
    private Map<String, RelevanceMatch> relevanceMatches;

    @SerializedName("OFFER_RETARGETING")
    private Map<String, OfferRetargeting> offerRetargetings;

    @SerializedName("ProductTypeCoef")
    private ProductTypeCoef productTypeCoef;

    @SerializedName("PageBlocks")
    private List<PageBlock> pageBlocks;

    @SerializedName("TargetTags")
    private List<String> targetTags;

    @SerializedName("PageGroupTags")
    private List<String> pageGroupTags;

    @SerializedName("AdGroupLevel")
    private Long level;

    @SerializedName("MaxRF")
    private Integer maxRF;

    @SerializedName("RFDays")
    private Integer rfDays;

    @SerializedName("StartTime")
    private String startTime;

    @SerializedName("FinishTime")
    private String finishTime;

    @SerializedName("AdditionalTargetings")
    private Map<Long, AdditionalTargeting> additionalTargetings;

    @SerializedName("AudienceSegmentGoalIds")
    private List<Long> audienceSegmentGoalIds;

    @SerializedName("MatchPriority")
    private Integer matchPriority;

    @SerializedName("TargetingExpression")
    private List<List<BsAtom>> targetingExpression;

    public Phrase getPhrase(long bidsId) {
        if (phrases == null) {
            return null;
        }
        for (Map.Entry<String, Phrase> entry : phrases.entrySet()) {
            if (entry.getValue().getEid().equals("" + bidsId)) {
                return entry.getValue();
            }
        }
        return null;
    }

    public Banner getBanner(Long bid) {
        if (banners == null) {
            return null;
        }
        for (Map.Entry<String, Banner> entry : banners.entrySet()) {
            if (entry.getValue().getEid().equals("" + bid)) {
                return entry.getValue();
            }
        }
        return null;
    }

    public GoalContext getGoalContext(Long retId) {
        if (goalContexts == null) {
            return null;
        }
        for (Map.Entry<String, GoalContext> entry : goalContexts.entrySet()) {
            if (entry.getValue().getEid().equals("" + retId)) {
                return entry.getValue();
            }
        }
        return null;
    }

    public Dynamic getDynamic(long dynCondId) {
        if (dynamics == null) {
            return null;
        }
        for (Map.Entry<String, Dynamic> entry : dynamics.entrySet()) {
            if (entry.getValue().getEid().equals("" + dynCondId)) {
                return entry.getValue();
            }
        }
        return null;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getEid() {
        return eid;
    }

    public void setEid(String eid) {
        this.eid = eid;
    }

    public Map<String, Phrase> getPhrases() {
        return phrases;
    }

    public void setPhrases(Map<String, Phrase> phrases) {
        this.phrases = phrases;
    }

    public Map<String, Dynamic> getDynamics() {
        return dynamics;
    }

    public void setDynamics(Map<String, Dynamic> dynamics) {
        this.dynamics = dynamics;
    }

    public Map<String, GoalContext> getGoalContexts() {
        return goalContexts;
    }

    public void setGoalContexts(Map<String, GoalContext> goalContexts) {
        this.goalContexts = goalContexts;
    }

    public Map<String, Banner> getBanners() {
        return banners;
    }

    public void setBanners(Map<String, Banner> banners) {
        this.banners = banners;
    }

    public Integer getUpdateInfo() {
        return updateInfo;
    }

    public void setUpdateInfo(Integer updateInfo) {
        this.updateInfo = updateInfo;
    }

    public List<String> getGeo() {
        return geo;
    }

    public void setGeo(List<String> geo) {
        this.geo = geo;
    }

    public String getMobilePriceCoef() {
        return mobilePriceCoef;
    }

    public void setMobilePriceCoef(String mobilePriceCoef) {
        this.mobilePriceCoef = mobilePriceCoef;
    }

    public String getMobileIOSPriceCoef() {
        return mobileIOSPriceCoef;
    }

    public Context setMobileIOSPriceCoef(String mobileIOSPriceCoef) {
        this.mobileIOSPriceCoef = mobileIOSPriceCoef;
        return this;
    }

    public String getMobileAndroidPriceCoef() {
        return mobileAndroidPriceCoef;
    }

    public Context setMobileAndroidPriceCoef(String mobileAndroidPriceCoef) {
        this.mobileAndroidPriceCoef = mobileAndroidPriceCoef;
        return this;
    }

    public String getDesktopPriceCoef() {
        return desktopPriceCoef;
    }

    public Context setDesktopPriceCoef(String desktopPriceCoef) {
        this.desktopPriceCoef = desktopPriceCoef;
        return this;
    }

    public Map<String, RetargetingCoef> getRetargetingCoef() {
        return retargetingCoef;
    }

    public void setRetargetingCoef(Map<String, RetargetingCoef> retargetingCoef) {
        this.retargetingCoef = retargetingCoef;
    }

    public SocdemCoef getSocdemCoef() {
        return socdemCoef;
    }

    public void setSocdemCoef(SocdemCoef socdemCoef) {
        this.socdemCoef = socdemCoef;
    }

    public String getContentStoreAppID() {
        return contentStoreAppID;
    }

    public void setContentStoreAppID(String contentStoreAppID) {
        this.contentStoreAppID = contentStoreAppID;
    }

    public String getContentStoreName() {
        return contentStoreName;
    }

    public void setContentStoreName(String contentStoreName) {
        this.contentStoreName = contentStoreName;
    }

    public String getContentOSType() {
        return contentOSType;
    }

    public void setContentOSType(String contentOSType) {
        this.contentOSType = contentOSType;
    }

    public ContextDeviceTypeTargeting getDeviceTypeTargeting() {
        return deviceTypeTargeting;
    }

    public void setDeviceTypeTargeting(ContextDeviceTypeTargeting deviceTypeTargeting) {
        this.deviceTypeTargeting = deviceTypeTargeting;
    }

    public ContextNetworkTargeting getNetworkTargeting() {
        return networkTargeting;
    }

    public void setNetworkTargeting(ContextNetworkTargeting networkTargeting) {
        this.networkTargeting = networkTargeting;
    }

    public Integer getMobileOSMinVersion() {
        return mobileOSMinVersion;
    }

    public void setMobileOSMinVersion(Integer mobileOSMinVersion) {
        this.mobileOSMinVersion = mobileOSMinVersion;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Map<String, Filter> getFilters() {
        return filters;
    }

    public Filter getFilter(int filterId) {
        if (getFilters() == null) {
            return null;
        }
        return getFilters().get("F_" + filterId);
    }

    public void setFilters(Map<String, Filter> filters) {
        this.filters = filters;
    }

    public void setResources(Resources resources) {
        this.resources = resources;
    }

    public Resources getResources() {
        return resources;
    }

    public List<String> getMinusPhrases() {
        return minusPhrases;
    }

    public void setMinusPhrases(List<String> minusPhrases) {
        this.minusPhrases = minusPhrases;
    }

    public Map<String, RelevanceMatch> getRelevanceMatches() {
        return relevanceMatches;
    }

    public RelevanceMatch getRelevanceMatch(Long relevanceMatchId) {
        if (relevanceMatches == null) {
            return null;
        }
        for (Map.Entry<String, RelevanceMatch> entry : relevanceMatches.entrySet()) {
            if (entry.getValue().getEid().equals("" + relevanceMatchId)) {
                return entry.getValue();
            }
        }
        return null;
    }

    public void setRelevanceMatches(Map<String, RelevanceMatch> relevanceMatches) {
        this.relevanceMatches = relevanceMatches;
    }

    public Map<String, OfferRetargeting> getOfferRetargetings() {
        return offerRetargetings;
    }

    public OfferRetargeting getOfferRetargeting(Long offerRetargetingId) {
        if (offerRetargetings == null) {
            return null;
        }
        for (Map.Entry<String, OfferRetargeting> entry : offerRetargetings.entrySet()) {
            if (entry.getValue().getEid().equals("" + offerRetargetingId)) {
                return entry.getValue();
            }
        }
        return null;
    }

    public void setOfferRetargetings(Map<String, OfferRetargeting> offerRetargetings) {
        this.offerRetargetings = offerRetargetings;
    }

    public ProductTypeCoef getProductTypeCoef() {
        return productTypeCoef;
    }

    public void setProductTypeCoef(ProductTypeCoef productTypeCoef) {
        this.productTypeCoef = productTypeCoef;
    }

    public List<PageBlock> getPageBlocks() {
        return pageBlocks;
    }

    public void setPageBlocks(List<PageBlock> pageBlocks) {
        this.pageBlocks = pageBlocks;
    }

    @Nullable
    public List<String> getTargetTags() {
        return targetTags;
    }

    @Nullable
    public List<String> getPageGroupTags() {
        return pageGroupTags;
    }

    public ExpressionCoefs getExpressionCoefs() {
        return expressionCoefs;
    }

    public void setExpressionCoefs(ExpressionCoefs expressionCoefs) {
        this.expressionCoefs = expressionCoefs;
    }

    public Long getLevel() {
        return level;
    }

    public void setLevel(Long level) {
        this.level = level;
    }

    public Integer getMaxRF() {
        return maxRF;
    }

    public Context setMaxRF(Integer maxRF) {
        this.maxRF = maxRF;
        return this;
    }

    public Integer getRfDays() {
        return rfDays;
    }

    public Context setRfDays(Integer rfDays) {
        this.rfDays = rfDays;
        return this;
    }

    public String getStartTime() {
        return startTime;
    }

    public Context setStartTime(String startTime) {
        this.startTime = startTime;
        return this;
    }

    public String getFinishTime() {
        return finishTime;
    }

    public Context setFinishTime(String finishTime) {
        this.finishTime = finishTime;
        return this;
    }

    public Map<Long, AdditionalTargeting> getAdditionalTargetings() {
        return additionalTargetings;
    }

    public void setAdditionalTargetings(
            Map<Long, AdditionalTargeting> additionalTargetings) {
        this.additionalTargetings = additionalTargetings;
    }

    public List<Long> getAudienceSegmentGoalIds() {
        return audienceSegmentGoalIds;
    }

    public void withAudienceSegmentGoalIds(List<Long> audienceSegmentGoalIds) {
        this.audienceSegmentGoalIds = audienceSegmentGoalIds;
    }

    public Integer getMatchPriority() {
        return matchPriority;
    }

    public void setMatchPriority(Integer matchPriority) {
        this.matchPriority = matchPriority;
    }

    public List<List<BsAtom>> getTargetingExpression() {
        return targetingExpression;
    }

    public Context setTargetingExpression(List<List<BsAtom>> targetingExpression) {
        this.targetingExpression = targetingExpression;
        return this;
    }
}
