package ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata;

import com.google.gson.annotations.SerializedName;

public class Image {

    public static final String URL = "URL";
    public static final String WIDTH = "Width";
    public static final String HEIGHT = "Height";
    public static final String SMART_CENTER = "SmartCenter";

    @SerializedName(URL)
    private String url;

    @SerializedName(WIDTH)
    private Integer width;

    @SerializedName(HEIGHT)
    private Integer height;

    @SerializedName(SMART_CENTER)
    private SmartCenter smartCenter;

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Image withUrl(String url) {
        this.url = url;
        return this;
    }

    public Integer getWidth() {
        return width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public Image withWidth(Integer width) {
        this.width = width;
        return this;
    }

    public Integer getHeight() {
        return height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }


    public Image withHeight(Integer height) {
        this.height = height;
        return this;
    }

    public SmartCenter getSmartCenter() {
        return smartCenter;
    }

    public void setSmartCenter(SmartCenter smartCenter) {
        this.smartCenter = smartCenter;
    }

    public Image withSmartCenter(SmartCenter smartCenter) {
        this.smartCenter = smartCenter;
        return this;
    }
}
