package ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata;

import com.google.gson.annotations.SerializedName;

public class ImageSizeDescription {

    public static final String WIDTH = "width";
    public static final String HEIGHT = "height";
    public static final String SMART_CENTER = "smart-center";
    public static final String SMART_CENTERS = "smart-centers";
    public static final String PATH = "path";

    @SerializedName(PATH)
    private String path;

    @SerializedName(WIDTH)
    private Integer width;

    @SerializedName(HEIGHT)
    private Integer height;

    @SerializedName(SMART_CENTER)
    private SmartCenter smartCenter;

    @SerializedName(SMART_CENTERS)
    private SmartCenters knownSmartCenters;

    public Integer getWidth() {
        return width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public ImageSizeDescription withWidth(Integer width) {
        this.width = width;
        return this;
    }

    public Integer getHeight() {
        return height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }


    public ImageSizeDescription withHeight(Integer height) {
        this.height = height;
        return this;
    }

    public SmartCenter getSmartCenter() {
        return smartCenter;
    }

    public void setSmartCenter(SmartCenter smartCenter) {
        this.smartCenter = smartCenter;
    }

    public ImageSizeDescription withSmartCenter(SmartCenter smartCenter) {
        this.smartCenter = smartCenter;
        return this;
    }

    public String getPath() {
        return path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public ImageSizeDescription withPath(String path) {
        this.path = path;
        return this;
    }

    public SmartCenters getKnownSmartCenters() {
        return knownSmartCenters;
    }

    public void setKnownSmartCenters(
            SmartCenters knownSmartCenters)
    {
        this.knownSmartCenters = knownSmartCenters;
    }

    public ImageSizeDescription withKnownSmartCenters(
            SmartCenters knownSmartCenters)
    {
        this.knownSmartCenters = knownSmartCenters;
        return this;
    }
}
