package ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata;

import com.google.gson.annotations.SerializedName;

import java.util.List;

public class Price {

    @SerializedName("AutoBudget")
    private Integer autoBudget;

    @SerializedName("AutoBudgetPriority")
    private String autoBudgetPriority;

    @SerializedName("BannerGroupEID")
    private String bannerGroupEid;

    @SerializedName("CurrencyISOCode")
    private Integer currencyIsoCode;

    @SerializedName("AutoBroker")
    private Integer autoBroker;

    @SerializedName("IndependentBids")
    private Integer independentBids;

    @SerializedName("OrderID")
    private String orderId;

    @SerializedName("QueueSetTime")
    private String queueSetTime;

    @SerializedName("hits")
    private String hits;

    @SerializedName("pid")
    private String pid;

    @SerializedName("PhraseID")
    private String phraseId;

    @SerializedName("cid")
    private String cid;

    @SerializedName("id")
    private String id;

    @SerializedName("price")
    private String price;

    @SerializedName("price_context")
    private Double priceContext;

    @SerializedName("ContextPriceCoef")
    private Integer contextPriceCoef;

    @SerializedName("AutoBudgetNetCPCOptimize")
    private Integer autoBudgetNetCPCOptimize;

    @SerializedName("ret_id")
    private String retId;

    @SerializedName("TargetType")
    private List<Integer> targetType;


    public Integer getAutoBudget() {
        return autoBudget;
    }

    public String getAutoBudgetPriority() {
        return autoBudgetPriority;
    }

    public String getBannerGroupEid() {
        return bannerGroupEid;
    }

    public Integer getCurrencyIsoCode() {
        return currencyIsoCode;
    }

    public Integer getAutoBroker() {
        return autoBroker;
    }

    public Integer getIndependentBids() {
        return independentBids;
    }

    public String getOrderId() {
        return orderId;
    }

    public String getQueueSetTime() {
        return queueSetTime;
    }

    public String getHits() {
        return hits;
    }

    public String getPid() {
        return pid;
    }

    public String getPhraseId() {
        return phraseId;
    }

    public String getCid() {
        return cid;
    }

    public String getId() {
        return id;
    }

    public String getPrice() {
        return price;
    }

    public Double getPriceContext() {
        return priceContext;
    }

    public Integer getContextPriceCoef() {
        return contextPriceCoef;
    }

    public Integer getAutoBudgetNetCPCOptimize() {
        return autoBudgetNetCPCOptimize;
    }

    public List<Integer> getTargetType() {
        return targetType;
    }

    public Price withAutoBudget(Integer autoBudget) {
        this.autoBudget = autoBudget;
        return this;
    }

    public Price withAutoBudgetPriority(String autoBudgetPriority) {
        this.autoBudgetPriority = autoBudgetPriority;
        return this;
    }

    public Price withBannerGroupEid(String bannerGroupEid) {
        this.bannerGroupEid = bannerGroupEid;
        return this;
    }

    public Price withCurrencyIsoCode(Integer currencyIsoCode) {
        this.currencyIsoCode = currencyIsoCode;
        return this;
    }

    public Price withAutoBroker(Integer autoBroker) {
        this.autoBroker = autoBroker;
        return this;
    }

    public Price withIndependentBids(Integer independentBids) {
        this.independentBids = independentBids;
        return this;
    }

    public Price withOrderId(String orderId) {
        this.orderId = orderId;
        return this;
    }

    public Price withQueueSetTime(String queueSetTime) {
        this.queueSetTime = queueSetTime;
        return this;
    }

    public Price withHits(String hits) {
        this.hits = hits;
        return this;
    }

    public Price withPid(String pid) {
        this.pid = pid;
        return this;
    }

    public Price withPhraseId(String phraseId) {
        this.phraseId = phraseId;
        return this;
    }

    public Price withCid(String cid) {
        this.cid = cid;
        return this;
    }

    public Price withId(String id) {
        this.id = id;
        return this;
    }

    public Price withPrice(String price) {
        this.price = price;
        return this;
    }

    public Price withPriceContext(Double priceContext) {
        this.priceContext = priceContext;
        return this;
    }

    public Price withContextPriceCoef(Integer contextPriceCoef) {
        this.contextPriceCoef = contextPriceCoef;
        return this;
    }

    public Price withAutoBudgetNetCPCOptimize(Integer autoBudgetNetCPCOptimize) {
        this.autoBudgetNetCPCOptimize = autoBudgetNetCPCOptimize;
        return this;
    }

    public Price withTargetType(List<Integer> targetType) {
        this.targetType = targetType;
        return this;
    }

    public void setAutoBudget(Integer autoBudget) {
        this.autoBudget = autoBudget;
    }

    public void setAutoBudgetPriority(String autoBudgetPriority) {
        this.autoBudgetPriority = autoBudgetPriority;
    }

    public void setBannerGroupEid(String bannerGroupEid) {
        this.bannerGroupEid = bannerGroupEid;
    }

    public void setCurrencyIsoCode(Integer currencyIsoCode) {
        this.currencyIsoCode = currencyIsoCode;
    }

    public void setAutoBroker(Integer autoBroker) {
        this.autoBroker = autoBroker;
    }

    public void setIndependentBids(Integer independentBids) {
        this.independentBids = independentBids;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public void setQueueSetTime(String queueSetTime) {
        this.queueSetTime = queueSetTime;
    }

    public void setHits(String hits) {
        this.hits = hits;
    }

    public void setPid(String pid) {
        this.pid = pid;
    }

    public void setPhraseId(String phraseId) {
        this.phraseId = phraseId;
    }

    public void setCid(String cid) {
        this.cid = cid;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setPrice(String price) {
        this.price = price;
    }

    public void setPriceContext(Double priceContext) {
        this.priceContext = priceContext;
    }

    public void setContextPriceCoef(Integer contextPriceCoef) {
        this.contextPriceCoef = contextPriceCoef;
    }

    public void setAutoBudgetNetCPCOptimize(Integer autoBudgetNetCPCOptimize) {
        this.autoBudgetNetCPCOptimize = autoBudgetNetCPCOptimize;
    }

    public void setTargetType(List<Integer> targetType) {
        this.targetType = targetType;
    }

    public String getRetId() {
        return retId;
    }

    public void setRetId(String retId) {
        this.retId = retId;
    }
}
