package ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata;

import com.google.gson.annotations.SerializedName;

public class RelevantMatchPrice {

    @SerializedName("AutoBudget")
    private Integer autoBudget;

    @SerializedName("AutoBudgetPriority")
    private Integer autoBudgetPriority;

    @SerializedName("BannerGroupEID")
    private Long bannerGroupEid;

    @SerializedName("CurrencyISOCode")
    private Integer currencyIsoCode;

    @SerializedName("IndependentBids")
    private Integer independentBids;

    @SerializedName("OrderID")
    private Long orderId;

    @SerializedName("QueueSetTime")
    private String queueSetTime;

    @SerializedName("pid")
    private Long pid;

    @SerializedName("cid")
    private Long cid;

    @SerializedName("price")
    private Double price;

    @SerializedName("price_context")
    private Double priceContext;

    @SerializedName("ContextPriceCoef")
    private Integer contextPriceCoef;

    @SerializedName("AutoBudgetNetCPCOptimize")
    private Integer autoBudgetNetCPCOptimize;

    @SerializedName("RelevanceMatchID")
    private Long relevanceMatchId;

    @SerializedName("RelevanceMatchType")
    private String relevanceMatchType;

    public Integer getAutoBudget() {
        return autoBudget;
    }

    public Integer getAutoBudgetPriority() {
        return autoBudgetPriority;
    }

    public Long getBannerGroupEid() {
        return bannerGroupEid;
    }

    public Integer getCurrencyIsoCode() {
        return currencyIsoCode;
    }

    public Integer getIndependentBids() {
        return independentBids;
    }

    public Long getOrderId() {
        return orderId;
    }

    public String getQueueSetTime() {
        return queueSetTime;
    }

    public Long getPid() {
        return pid;
    }

    public Long getCid() {
        return cid;
    }

    public Double getPrice() {
        return price;
    }

    public Double getPriceContext() {
        return priceContext;
    }

    public Integer getContextPriceCoef() {
        return contextPriceCoef;
    }

    public Integer getAutoBudgetNetCPCOptimize() {
        return autoBudgetNetCPCOptimize;
    }

    public Long getRelevanceMatchId() {
        return relevanceMatchId;
    }

    public RelevantMatchPrice withAutoBudget(Integer autoBudget) {
        this.autoBudget = autoBudget;
        return this;
    }

    public RelevantMatchPrice withAutoBudgetPriority(Integer autoBudgetPriority) {
        this.autoBudgetPriority = autoBudgetPriority;
        return this;
    }

    public RelevantMatchPrice withBannerGroupEid(Long bannerGroupEid) {
        this.bannerGroupEid = bannerGroupEid;
        return this;
    }

    public RelevantMatchPrice withCurrencyIsoCode(Integer currencyIsoCode) {
        this.currencyIsoCode = currencyIsoCode;
        return this;
    }

    public RelevantMatchPrice withIndependentBids(Integer independentBids) {
        this.independentBids = independentBids;
        return this;
    }

    public RelevantMatchPrice withOrderId(Long orderId) {
        this.orderId = orderId;
        return this;
    }

    public RelevantMatchPrice withQueueSetTime(String queueSetTime) {
        this.queueSetTime = queueSetTime;
        return this;
    }

    public RelevantMatchPrice withPid(Long pid) {
        this.pid = pid;
        return this;
    }

    public RelevantMatchPrice withCid(Long cid) {
        this.cid = cid;
        return this;
    }

    public RelevantMatchPrice withPrice(Double price) {
        this.price = price;
        return this;
    }

    public RelevantMatchPrice withPriceContext(Double priceContext) {
        this.priceContext = priceContext;
        return this;
    }

    public RelevantMatchPrice withContextPriceCoef(Integer contextPriceCoef) {
        this.contextPriceCoef = contextPriceCoef;
        return this;
    }

    public RelevantMatchPrice withAutoBudgetNetCPCOptimize(Integer autoBudgetNetCPCOptimize) {
        this.autoBudgetNetCPCOptimize = autoBudgetNetCPCOptimize;
        return this;
    }

    public RelevantMatchPrice withRelevanceMatchId(Long relevanceMatchId) {
        this.relevanceMatchId = relevanceMatchId;
        return this;
    }

    public void setAutoBudget(Integer autoBudget) {
        this.autoBudget = autoBudget;
    }

    public void setAutoBudgetPriority(Integer autoBudgetPriority) {
        this.autoBudgetPriority = autoBudgetPriority;
    }

    public void setBannerGroupEid(Long bannerGroupEid) {
        this.bannerGroupEid = bannerGroupEid;
    }

    public void setCurrencyIsoCode(Integer currencyIsoCode) {
        this.currencyIsoCode = currencyIsoCode;
    }

    public void setIndependentBids(Integer independentBids) {
        this.independentBids = independentBids;
    }

    public void setOrderId(Long orderId) {
        this.orderId = orderId;
    }

    public void setQueueSetTime(String queueSetTime) {
        this.queueSetTime = queueSetTime;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }

    public void setCid(Long cid) {
        this.cid = cid;
    }

    public void setPrice(Double price) {
        this.price = price;
    }

    public void setPriceContext(Double priceContext) {
        this.priceContext = priceContext;
    }

    public void setContextPriceCoef(Integer contextPriceCoef) {
        this.contextPriceCoef = contextPriceCoef;
    }

    public void setAutoBudgetNetCPCOptimize(Integer autoBudgetNetCPCOptimize) {
        this.autoBudgetNetCPCOptimize = autoBudgetNetCPCOptimize;
    }

    public void setRelevanceMatchId(Long relevanceMatchId) {
        this.relevanceMatchId = relevanceMatchId;
    }

    public String getRelevanceMatchType() { return relevanceMatchType; }

    public void setRelevanceMatchType(String relevanceMatchType) { this.relevanceMatchType = relevanceMatchType; }

    public RelevantMatchPrice withRelevanceMatchType(String relevanceMatchType) {
        this.relevanceMatchType = relevanceMatchType;
        return this;
    }
}
