package ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata;

import java.util.List;

import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;

import ru.yandex.autotests.directapi.darkside.model.internalads.BsTemplateVariables;
import ru.yandex.autotests.irt.testutils.json.JsonUtils;

/**
 * Created by pashkus on 05.04.16.
 * https://st.yandex-team.ru/TESTIRT-8695
 */
public class Resources {

    public static final String AUTO_VIDEO_CREATIVE = "AutoVideoCreative";

    @SerializedName("ClickUrlTail")
    private String clickUrlTail;
    // "://avatars.mdst/namespace/group/key/orig", 240, 400
    //ссылка для загрузки изображения, ширина, высота
    @SerializedName("MediaImage")
    private String[] mediaImage;

    @SerializedName("Creative")
    private List<Long> creative;

    @SerializedName("Domain")
    private String domain;

    @SerializedName("Body")
    private String body;

    @SerializedName("Url")
    private String url;

    @SerializedName("Title")
    private String title;

    @SerializedName("AutoVideoCreative")
    private Long autoVideoCreative;

    @SerializedName("RenderInfo")
    private String renderInfo;

    @SerializedName("CreativeHref1")
    private String creativeHref1;

    @SerializedName("CreativeHref2")
    private String creativeHref2;

    @SerializedName("CreativeHref3")
    private String creativeHref3;

    @SerializedName("CreativeTurboLandingHref1")
    private String creativeTurboLandingHref1;

    @SerializedName("CreativeTurboLandingHref2")
    private String creativeTurboLandingHref2;

    @SerializedName("CreativeTurboLandingHref3")
    private String creativeTurboLandingHref3;

    @SerializedName("Experiment")
    private Object experiment;

    @SerializedName("Dialog")
    private ResourcesDialog dialog;

    @SerializedName("CreativeComposedFrom")
    private String creativeComposedFrom;

    @SerializedName("TemplateVariables")
    private List<BsTemplateVariables> templateVariables;

    @SerializedName("UnifiedTemplateVariables")
    private List<BsTemplateVariables> unifiedTemplateVariables;

    @SerializedName("VideoMetadata")
    private String videoMetadata;

    @SerializedName("PackshotHref")
    private String packshotHref;

    @SerializedName("Metadata")
    private String metadata;

    @SerializedName("VisitHref")
    private String visitHref;

    @SerializedName("TurboGalleryHref")
    private String turboGalleryHref;

    public String getExperiment() {
        return JsonUtils.toLowCaseString(experiment);
    }

    public void setExperiment(String experiment) {
        this.experiment = new JsonParser().parse(experiment).getAsJsonObject();
    }

    public ResourcesDialog getDialog() {
        return this.dialog;
    }

    public void setDialog(ResourcesDialog dialog) {
        this.dialog = dialog;
    }

    public Resources withDialog(ResourcesDialog dialog) {
        this.dialog = dialog;
        return this;
    }

    public void setClickUrlTail(String clickUrlTail) {
        this.clickUrlTail = clickUrlTail;
    }

    public String getClickUrlTail() {
        return clickUrlTail;
    }

    public String[] getMediaImage() {
        return mediaImage;
    }

    public void setMediaImage(String[] mediaImage) {
        this.mediaImage = mediaImage;
    }

    public Resources withMediaImage(String[] mediaImage) {
        this.mediaImage = mediaImage;
        return this;
    }

    public String getDomain() {
        return domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public Resources withDomain(String domain) {
        this.domain = domain;
        return this;
    }

    public String getBody() {
        return body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public Resources withBody(String body) {
        this.body = body;
        return this;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Resources withUrl(String url) {
        this.url = url;
        return this;
    }

    public List<Long> getCreative() {
        return creative;
    }

    public void setCreative(List<Long> creative) {
        this.creative = creative;
    }

    public Resources withCreative(List<Long> creative) {
        this.creative = creative;
        return this;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Resources withTitle(String title) {
        this.title = title;
        return this;
    }

    public Long getAutoVideoCreative() {
        return autoVideoCreative;
    }

    public void setAutoVideoCreative(Long creative) {
        this.autoVideoCreative = creative;
    }

    public Resources withAutoVideoCreative(Long creative) {
        this.autoVideoCreative = creative;
        return this;
    }

    public String getCreativeHref1() {
        return creativeHref1;
    }

    public void setCreativeHref1(String creativeHref1) {
        this.creativeHref1 = creativeHref1;
    }

    public Resources withCreativeHref1(String creativeHref1) {
        this.creativeHref1 = creativeHref1;
        return this;
    }

    public String getCreativeHref2() {
        return creativeHref2;
    }

    public void setCreativeHref2(String creativeHref2) {
        this.creativeHref2 = creativeHref2;
    }

    public String getCreativeHref3() {
        return creativeHref3;
    }

    public void setCreativeHref3(String creativeHref3) {
        this.creativeHref3 = creativeHref3;
    }

    public String getCreativeTurboLandingHref1() {
        return creativeTurboLandingHref1;
    }

    public void setCreativeTurboLandingHref1(String creativeTurboLandingHref1) {
        this.creativeTurboLandingHref1 = creativeTurboLandingHref1;
    }

    public Resources withCreativeTurboLandingHref1(String creativeTurboLandingHref) {
        this.creativeTurboLandingHref1 = creativeTurboLandingHref;
        return this;
    }

    public String getCreativeTurboLandingHref2() {
        return creativeTurboLandingHref2;
    }

    public void setCreativeTurboLandingHref2(String creativeTurboLandingHref2) {
        this.creativeTurboLandingHref2 = creativeTurboLandingHref2;
    }

    public Resources withCreativeTurboLandingHref2(String creativeTurboLandingHref) {
        this.creativeTurboLandingHref2 = creativeTurboLandingHref;
        return this;
    }

    public String getCreativeTurboLandingHref3() {
        return creativeTurboLandingHref3;
    }

    public void setCreativeTurboLandingHref3(String creativeTurboLandingHref3) {
        this.creativeTurboLandingHref3 = creativeTurboLandingHref3;
    }

    public Resources withCreativeTurboLandingHref3(String creativeTurboLandingHref) {
        this.creativeTurboLandingHref3 = creativeTurboLandingHref;
        return this;
    }

    public String getRenderInfo() {
        return renderInfo;
    }

    public void setRenderInfo(String renderInfo) {
        this.renderInfo = renderInfo;
    }

    public Resources withRenderInfo(String renderInfo) {
        this.renderInfo = renderInfo;
        return this;
    }

    public String getCreativeComposedFrom() {
        return creativeComposedFrom;
    }

    public void setCreativeComposedFrom(String creativeComposedFrom) {
        this.creativeComposedFrom = creativeComposedFrom;
    }

    public Resources withCreativeComposedFrom(String creativeComposedFrom) {
        this.creativeComposedFrom = creativeComposedFrom;
        return this;
    }

    public String getVideoMetadata() {
        return videoMetadata;
    }

    public void setVideoMetadata(String videoMetadata) {
        this.videoMetadata = videoMetadata;
    }

    public Resources withVideoMetadata(String videoMetadata) {
        this.videoMetadata = videoMetadata;
        return this;
    }

    public String getPackshotHref() {
        return packshotHref;
    }

    public void setPackshotHref(String packshotHref) {
        this.packshotHref = packshotHref;
    }

    public Resources withPackshotHref(String packshotHref) {
        this.packshotHref = packshotHref;
        return this;
    }

    public String getMetadata() {
        return metadata;
    }

    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }

    public Resources withMetadata(String metadata) {
        this.metadata = metadata;
        return this;
    }

    public String getVisitHref() {
        return visitHref;
    }

    public void setVisitHref(String visitHref) {
        this.visitHref = visitHref;
    }

    public Resources withVisitUrl(String visitUrl) {
        this.visitHref = visitUrl;
        return this;
    }

    public String getTurboGalleryHref() {
        return turboGalleryHref;
    }

    public void setTurboGalleryHref(String turboGalleryHref) {
        this.turboGalleryHref = turboGalleryHref;
    }

    public Resources withTurboGalleryHref(String turboGalleryHref) {
        this.turboGalleryHref = turboGalleryHref;
        return this;
    }

    public List<BsTemplateVariables> getTemplateVariables() {
        return templateVariables;
    }

    public void setTemplateVariables(List<BsTemplateVariables> templateVariables) {
        this.templateVariables = templateVariables;
    }

    public Resources withTemplateVariables(List<BsTemplateVariables> templateVariables) {
        this.templateVariables = templateVariables;
        return this;
    }

    public List<BsTemplateVariables> getUnifiedTemplateVariables() {
        return unifiedTemplateVariables;
    }

    public void setUnifiedTemplateVariables(List<BsTemplateVariables> unifiedTemplateVariables) {
        this.unifiedTemplateVariables = unifiedTemplateVariables;
    }

    public Resources withUnifiedTemplateVariables(List<BsTemplateVariables> unifiedTemplateVariables) {
        this.unifiedTemplateVariables = unifiedTemplateVariables;
        return this;
    }
}
