package ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata;

import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonProperty;

public class VideoMetadata {

    @JsonProperty("Title")
    private String title;

    @JsonProperty("Passage")
    private List<String> passage;

    public String getTitle() {
        return title;
    }

    public VideoMetadata withTitle(String title) {
        this.title = title;
        return this;
    }

    public List<String> getPassage() {
        return passage;
    }

    public VideoMetadata withPassage(List<String> passage) {
        this.passage = passage;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        VideoMetadata that = (VideoMetadata) o;
        return Objects.equals(title, that.title) &&
                Objects.equals(passage, that.passage);
    }

    @Override
    public int hashCode() {
        return Objects.hash(title, passage);
    }
}
