package ru.yandex.autotests.directapi.darkside.model.bslogs.converters;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.MobileContentOsType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.MobileContentStatusiconmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.MobileContentRecord;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.darkside.model.bslogs.mobile.Icon;
import ru.yandex.autotests.directapi.darkside.model.bslogs.mobile.IconType;
import ru.yandex.autotests.directapi.darkside.model.bslogs.mobile.MobileContentData;
import ru.yandex.autotests.directapi.darkside.model.bslogs.mobile.Price;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;


/**
 * Created by buhter on 05/08/15.
 */
public class MobileContentToMobileContentDataConverter {
    private final static Type COMPLEX_MAP_TYPE = new TypeToken<Map<String, Map<String, JsonObject>>>() {
    }.getType();

    public static MobileContentData convertMobileContentToMobileContentData(MobileContentRecord mobileContent) {
        MobileContentData result = new MobileContentData();
        result.setAppSizeBytes(mobileContent.getAppSizeBytes());
        result.setRating(mobileContent.getRating().doubleValue());
        result.setReviewCount(mobileContent.getRatingVotes());
        result.setStoreCountry(mobileContent.getStoreCountry().toUpperCase());
        result.setStoreName(getStoreNameForOSType(mobileContent.getOsType().getLiteral()));
        result.setStoreAppId(mobileContent.getBundleId());
        result.setMobileAppId(mobileContent.getMobileContentId());
        result.setIsAccessible(mobileContent.getIsAvailable() == 1);
        result.setOsType(mobileContent.getOsType().getLiteral());
        result.setAgeLabel(Long.valueOf(mobileContent.getAgeLabel().getLiteral().replace("+", "")));
        result.setStoreContentId(mobileContent.getStoreContentId());
        Map<String, Map<String, Price>> prices = new HashMap<>();
        Map<String, Map<String, JsonObject>> dbPricesMap = new Gson().fromJson(mobileContent.getPricesJson()
                , COMPLEX_MAP_TYPE);

        dbPricesMap.forEach((country, actionPricesMap) -> {
            Map<String, Price> localPricesMap = new HashMap<>();
            actionPricesMap.forEach((action, dbPrice) -> {
                boolean knownCurrency = true;
                try {
                    Currency.valueOf(dbPrice.get(Price.PRICE_CURRENCY).getAsString());
                } catch (IllegalArgumentException e) {
                    knownCurrency = false;
                }
                if (knownCurrency) {
                    Price price = new Price();
                    price.setPrice(dbPrice.get(Price.PRICE).getAsDouble());
                    price.setPriceCurrency(Currency.getFor(dbPrice.get(Price.PRICE_CURRENCY).getAsString()).getIsoCode());
                    localPricesMap.put(action, price);
                }
            });
            if (localPricesMap.size() > 0) {
                prices.put(country, localPricesMap);
            }
        });

        result.setPrices(prices);

        if ((mobileContent.getIconHash() != null)
                && mobileContent.getStatusiconmoderate().equals(MobileContentStatusiconmoderate.Yes)) {
            String baseOSUrl = getBaseOSUrl(mobileContent.getOsType().getLiteral());
            Map<String, Icon> icons = new HashMap<>();
            Arrays.asList(IconType.values()).forEach(iconType -> {
                Icon icon = new Icon();
                icon.setHeight(iconType.height());
                icon.setWidth(iconType.width());
                icon.setUrl(baseOSUrl + mobileContent.getIconHash() + "/" + iconType.type());
                icons.put(iconType.type(), icon);
            });
            result.setIcons(icons);
        }
        return result;
    }

    private static String getBaseOSUrl(String type) {
        if (type.equals(MobileContentOsType.Android.getLiteral())) {
            return Icon.BASE_ANDROID_ICON_URL;
        }
        if (type.equals(MobileContentOsType.iOS.getLiteral())) {
            return Icon.BASE_IOS_ICON_URL;
        }
        return null;
    }

    public static String getStoreNameForOSType(String type) {
        if (type.equals(MobileContentOsType.Android.getLiteral())) {
            return "Google Play";
        }
        if (type.equals(MobileContentOsType.iOS.getLiteral())) {
            return "App Store";
        }
        return null;
    }

}
