package ru.yandex.autotests.directapi.darkside.model.internalads;

import static ru.yandex.autotests.directapi.darkside.model.internalads.AdditionalTargetingType.BOOLEAN;
import static ru.yandex.autotests.directapi.darkside.model.internalads.AdditionalTargetingType.LIST;

/**
 * Параметр, передаваемый в БК в КНФ-формулах
 * Для каждого параметра указано, какой именно кейворд ожидает получить БК и значения операций
 */
public enum AdditionalTargetingParameter {

    YANDEXUIDS(LIST, "uniq-id", "like", "not like", "", "", false, false),
    DEVICE_NAMES(LIST, "uatraits-device-name", "icase match", "icase not match", "", "", false, false),
    INTERFACE_LANGS(LIST, "lang", "icase match", "icase not match", "", "", false, false),
    DESKTOP_INSTALLED_APPS(LIST, "installed-yasoft", "equal", "not equal", "", "", false, false),
    QUERY_REFERERS(LIST, "referer", "like", "not like", "", "", false, false),
    USER_AGENT(LIST, "user-agent", "like", "not like", "", "", false, false),
    SHOW_DATES(LIST, "timestamp", "like", "not like", "", "", false, false),
    QUERY_OPTIONS(LIST, "options", "icase match", "icase not match", "", "", false, false),
    FEATURES_IN_PP(LIST, "enabled_features", "icase match", "icase not match", "", "", false, false),
    CLIDS(LIST, "stat-id", "equal", "not equal", "", "", false, false),
    CLID_TYPES(LIST, "clid-type", "match", "not match", "", "", false, false),
    TEST_IDS(LIST, "yabr_maj_v", "equal", "not equal", "", "", false, false),
    YS_COOKIES(LIST, "cookie-ys", "like", "not like", "", "", false, false),
    YP_COOKIES(LIST, "cookie-yp", "like", "not like", "", "", false, false),
    BROWSER_NAMES(LIST, "browser-name-and-version", "match name and version range", "not match name and version " +
            "range", "", "", true, true),
    BROWSER_ENGINES(LIST, "browser-engine-name-and-version", "match name and version range", "not match name and " +
            "version range", "", "", true, true),
    OS_FAMILIES(LIST, "os-family-and-version", "match name and version range", "not match name and version range",
            "", "", true, true),
    OS_NAMES(LIST, "os-name", "equal", "not equal", "", "", false, true),
    DEVICE_VENDORS(LIST, "device-vendor", "equal", "not equal", "", "", false, true),
    MOBILE_INSTALLED_APPS(LIST, "except-apps-on-cpi", "equal", "not equal", "", "", false, false),
    INTERNAL_NETWORK(BOOLEAN, "network-id", "equal", "not equal", "2", "2", false, false),
    IS_MOBILE(BOOLEAN, "device-is-mobile", "equal", "equal", "1", "0", false, false);

    private AdditionalTargetingType type;
    private String bsValue;
    private String targetingOperation;
    private String filteringOperation;
    private String targetingValue;
    private String filteringValue;
    private boolean versioned;
    private boolean isUatraitsTargeting;

    AdditionalTargetingParameter(AdditionalTargetingType type, String bsValue, String targetingOperation,
                                 String filteringOperation, String targetingValue, String filteringValue,
                                 boolean versioned, boolean isUatraitsTargeting) {
        this.type = type;
        this.bsValue = bsValue;
        this.targetingOperation = targetingOperation;
        this.filteringOperation = filteringOperation;
        this.targetingValue = targetingValue;
        this.filteringValue = filteringValue;
        this.versioned = versioned;
        this.isUatraitsTargeting = isUatraitsTargeting;
    }

    public String getBsValue() {
        return bsValue;
    }

    public String getTargetingOperation() {
        return targetingOperation;
    }

    public String getFilteringOperation() {
        return filteringOperation;
    }

    public AdditionalTargetingType getType() {
        return type;
    }

    public String getTargetingValue() {
        return targetingValue;
    }

    public String getFilteringValue() {
        return filteringValue;
    }

    public boolean isVersioned() {
        return versioned;
    }

    public boolean isUatraitsTargeting() {
        return isUatraitsTargeting;
    }

}
