package ru.yandex.autotests.directapi.darkside.model.internalads;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.Nullable;

import ru.yandex.autotests.irt.testutils.json.JsonUtils;


/**
 *  Создание значений таргетинга в виде json-объекта для записи в базу
 *
 *  Подойдет для таргетинга следующих типов:
 *   os_names - [{"targetingValueEntryId": 4}, {"targetingValueEntryId": 5}, ...]
 *  далее версионные таргетинги
 *   browser_engines - [{"targetingValueEntryId": 1, "min_version": "532", "max_version': '2345"} ]
 *   browser_names - [{"targetingValueEntryId": 2, "min_version": "10456", "max_version": "10987"}, {"targetingValueEntryId": 3}, ...]
 *   os_families - [{"targetingValueEntryId": 3, "min_version": "412"}, {"targetingValueEntryId": "4, "min_version": "9", "max_version": "10"}, ...]
 */
public class AdditionalTargetingValuesBuilder {

    private final List<AdgroupAdditionalVersionedTargetingValues> values = new ArrayList<>();

    public static AdditionalTargetingValuesBuilder init() {
        return new AdditionalTargetingValuesBuilder();
    }

    public AdditionalTargetingValuesBuilder addValue(Long targetingValueEntryId) {
        return addValue(targetingValueEntryId, null, null);
    }

    public AdditionalTargetingValuesBuilder addValue(Long targetingValueEntryId,
                                                     @Nullable String minVersion,
                                                     @Nullable String maxVersion) {
        values.add(new AdgroupAdditionalVersionedTargetingValues()
                .withTargetingValueEntryId(targetingValueEntryId)
                .withMinVersion(minVersion)
                .withMaxVersion(maxVersion));
        return this;
    }

    public List<AdgroupAdditionalVersionedTargetingValues> build() {
        return values;
    }

    public String buildJson() {
        return JsonUtils.toString(values);
    }

}
