package ru.yandex.autotests.directapi.darkside.model.internalads;


import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;

@JsonAdapter(BsTemplateVariablesJsonAdapter.class)
public class BsTemplateVariables {

    @SerializedName("template_resource_id")
    private Long templateResourceId;

    @SerializedName("value")
    private String value;

    @SerializedName("template_resource_no")
    private Short templateResourceNo;

    @SerializedName("template_part_no")
    private Integer templatePartNo;

    @SerializedName("width")
    private Integer width;

    @SerializedName("height")
    private Integer height;

    public Long getTemplateResourceId() {
        return templateResourceId;
    }

    public BsTemplateVariables withTemplateResourceId(Long templateResourceId) {
        this.templateResourceId = templateResourceId;
        return this;
    }

    public String getValue() {
        return value;
    }

    public BsTemplateVariables withValue(String value) {
        this.value = value;
        return this;
    }

    public Short getTemplateResourceNo() {
        return templateResourceNo;
    }

    public BsTemplateVariables withTemplateResourceNo(Short templateResourceNo) {
        this.templateResourceNo = templateResourceNo;
        return this;
    }

    public Integer getTemplatePartNo() {
        return templatePartNo;
    }

    public BsTemplateVariables withTemplatePartNo(Integer templatePartNo) {
        this.templatePartNo = templatePartNo;
        return this;
    }

    public Integer getWidth() {
        return width;
    }

    public BsTemplateVariables withWidth(Integer width) {
        this.width = width;
        return this;
    }

    public Integer getHeight() {
        return height;
    }

    public BsTemplateVariables withHeight(Integer height) {
        this.height = height;
        return this;
    }
}
