package ru.yandex.autotests.directapi.darkside.model.internalads;

import java.io.IOException;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;

public class BsTemplateVariablesJsonAdapter extends TypeAdapter<BsTemplateVariables> {

    @Override
    public void write(JsonWriter jsonWriter, BsTemplateVariables bsTemplateVariables)
            throws IOException {
        jsonWriter.beginObject();
        jsonWriter.name("Value").value(bsTemplateVariables.getValue());
        jsonWriter.name("TemplateResourceID").value(bsTemplateVariables.getTemplateResourceId());
        jsonWriter.name("TemplateResourceNo").value(bsTemplateVariables.getTemplateResourceNo());
        jsonWriter.name("TemplatePartNo").value(bsTemplateVariables.getTemplatePartNo());
        jsonWriter.name("Width").value(bsTemplateVariables.getWidth());
        jsonWriter.name("Height").value(bsTemplateVariables.getHeight());
        jsonWriter.endObject();
    }

    @Override
    public BsTemplateVariables read(JsonReader jsonReader) throws IOException {
        BsTemplateVariables result = new BsTemplateVariables();
        jsonReader.beginObject();
        while (jsonReader.hasNext()) {
            String name = jsonReader.nextName();
            switch (name) {
                case "Value":
                    result.withValue(jsonReader.nextString());
                    break;
                case "TemplateResourceID":
                    result.withTemplateResourceId(jsonReader.nextLong());
                    break;
                case "TemplateResourceNo":
                    result.withTemplateResourceNo((short) jsonReader.nextInt());
                    break;
                case "TemplatePartNo":
                    result.withTemplatePartNo(jsonReader.nextInt());
                    break;
                case "Width":
                    result.withWidth(jsonReader.nextInt());
                    break;
                case "Height":
                    result.withHeight(jsonReader.nextInt());
                    break;
                default:
                    jsonReader.skipValue();
                    break;
            }
        }
        jsonReader.endObject();
        return result;
    }


}
