package ru.yandex.autotests.directapi.darkside.model.internalads;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.gson.annotations.SerializedName;

@ParametersAreNonnullByDefault
public class MobileInstalledAppsTargetingValue {

    @SerializedName("mobileContentId")
    private Long mobileContentId;

    @SerializedName("storeUrl")
    private String storeUrl;

    public Long getMobileContentId() {
        return mobileContentId;
    }

    public MobileInstalledAppsTargetingValue withMobileContentId(Long mobileContentId) {
        this.mobileContentId = mobileContentId;
        return this;
    }

    /**
     * Хак для тестов: в storeUrl храним ContentStoreAppID + ContentStoreName, чтобы при построении expectedValues
     * не нужно было делать дополнительные запросы в базу. В транспорте это поле не используется
     * {@link TargetingExpressionBuilder#convertDbListValueToExpresionFormat}
     */
    public String getStoreUrl() {
        return storeUrl;
    }

    public MobileInstalledAppsTargetingValue withStoreUrl(String storeUrl) {
        this.storeUrl = storeUrl;
        return this;
    }

}
