package ru.yandex.autotests.directapi.darkside.model.internalads;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.autotests.irt.testutils.json.JsonUtils;

@ParametersAreNonnullByDefault
public class MobileInstalledAppsTargetingValuesBuilder {

    private final List<MobileInstalledAppsTargetingValue> values = new ArrayList<>();

    public static MobileInstalledAppsTargetingValuesBuilder init() {
        return new MobileInstalledAppsTargetingValuesBuilder();
    }

    public MobileInstalledAppsTargetingValuesBuilder addValue(Long mobileContentId, String storeUrl) {
        values.add(new MobileInstalledAppsTargetingValue()
                .withMobileContentId(mobileContentId)
                .withStoreUrl(storeUrl));
        return this;
    }

    public List<MobileInstalledAppsTargetingValue> build() {
        return values;
    }

    public String buildJson() {
        return JsonUtils.toString(values);
    }

}
