package ru.yandex.autotests.directapi.darkside.model.multipliers;


/**
 * Элементарная логическая операция [keyword, operation, value]
 * valueInteger и valueString разделены, чтобы явно проверять, в каких именно типах
 * мы отправляем значения кейвордов в БК
 */
public class DirectAtom {
    private String keyword;

    private String operation;

    private Integer valueInteger;

    private String valueString;

    public DirectAtom(String keyword, String operation, Integer valueInteger) {
        this.keyword = keyword;
        this.operation = operation;
        this.valueInteger = valueInteger;
    }

    public DirectAtom(String keyword, String operation, String valueString) {
        this.keyword = keyword;
        this.operation = operation;
        this.valueString = valueString;
    }

    public DirectAtom() {
    }

    public String getOperation() {
        return operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public DirectAtom withOperation(String operation) {
        this.operation = operation;
        return this;
    }

    public Integer getValueInteger() {
        return valueInteger;
    }

    public void setValueInteger(Integer valueInteger) {
        this.valueInteger = valueInteger;
    }

    public DirectAtom withValueInteger(Integer value) {
        this.valueInteger = value;
        return this;
    }

    public String getValueString() {
        return valueString;
    }

    public void setValueString(String valueString) {
        this.valueString = valueString;
    }

    public DirectAtom withValueString(String valueString) {
        this.valueString = valueString;
        return this;
    }

    public String getKeyword() {
        return keyword;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public DirectAtom withKeyword(String keyword) {
        this.keyword = keyword;
        return this;
    }

    @Override
    public String toString() {
        return "[ '" + keyword + "', '"
                + operation + "', '"
                + nvl(valueInteger) + nvl(valueString)
                + "' ]";
    }
    private static String nvl(Object o) {
        return o == null ? "" : o.toString();
    }
}
