package ru.yandex.autotests.directapi.darkside.model.multipliers;

/**
 * Параметр, передаваемый в БК в КНФ-формулах
 * Для каждого параметра указано, какой именно кейворд ожидает получить БК, и тип значения.
 */
public enum ExpressionParameter {
    CONTEXT_ID("goal-context-id", ExpressionParameterType.STRING),

    AGE("crypta-socdem-age", ExpressionParameterType.STRING),
    GENDER("crypta-socdem-gender", ExpressionParameterType.STRING),

    PREC_STRENGTH("prec_strength", ExpressionParameterType.STRING),
    CLOUDNESS("cloudness", ExpressionParameterType.STRING),
    TEMP("temp", ExpressionParameterType.STRING),

    TRAFFIC_JAM("traffic-jam", ExpressionParameterType.STRING),

    REGION_ID("reg-id", ExpressionParameterType.STRING),

    BRAND_SAFETY_CATEGORIES("brand-safety-categories", ExpressionParameterType.STRING),

    UNIQ_ID("uniq-id", ExpressionParameterType.STRING),
    UATRAITS_DEVICE_NAME("uatraits-device-name", ExpressionParameterType.STRING),
    LANG("lang", ExpressionParameterType.STRING),
    INSTALLED_YASOFT("installed-yasoft", ExpressionParameterType.STRING),
    REFERER("referer", ExpressionParameterType.STRING),
    USER_AGENT("user-agent", ExpressionParameterType.STRING),
    TIMESTAMP("timestamp", ExpressionParameterType.STRING),
    OPTIONS("options", ExpressionParameterType.STRING),
    STAT_ID("stat-id", ExpressionParameterType.STRING),
    CLID_TYPE("clid-type", ExpressionParameterType.STRING),
    YABR_MAJ_V("yabr_maj_v", ExpressionParameterType.STRING),
    COOKIE_YS("cookie-ys", ExpressionParameterType.STRING),
    COOKIE_YP("cookie-yp", ExpressionParameterType.STRING),
    NETWORK_ID("network-id", ExpressionParameterType.STRING),
    DEVICE_IS_MOBILE("device-is-mobile", ExpressionParameterType.STRING),
    CONTENT_CATEGORY("content-category", ExpressionParameterType.STRING),
    CONTENT_GENRE("content-genre", ExpressionParameterType.STRING),
    VISIT_GOAL("visit-goal", ExpressionParameterType.STRING),
    AUDITORIUM_GEOSEGMENTS("auditorium-geosegments", ExpressionParameterType.STRING),
    BROWSER_NAMES("browser-name-and-version", ExpressionParameterType.STRING),
    BROWSER_ENGINES("browser-engine-name-and-version", ExpressionParameterType.STRING),
    OS_FAMILIES("os-family-and-version", ExpressionParameterType.STRING),
    OS_NAMES("os-name", ExpressionParameterType.STRING),
    DEVICE_VENDORS("device-vendor", ExpressionParameterType.STRING),
    FEATURES_IN_PP("enabled_features", ExpressionParameterType.STRING),
    MOBILE_INSTALLED_APPS("except-apps-on-cpi", ExpressionParameterType.STRING);

    private String bsValue;
    private ExpressionParameterType type;

    ExpressionParameter(String bsValue, ExpressionParameterType type) {
        this.bsValue = bsValue;
        this.type = type;
    }

    public ExpressionParameterType getType() {
        return type;
    }

    public String getDirectValue() {
        return bsValue;
    }

    public String getBsValue() {
        return bsValue;
    }

    public static ExpressionParameter fromBsValue(String bsValue) {
        for (ExpressionParameter value : ExpressionParameter.values()) {
            if (value.bsValue.equals(bsValue)) {
                return value;
            }
        }
        throw new IllegalArgumentException("Unknown bs keyword " + bsValue);
    }
}
