package ru.yandex.autotests.directapi.darkside.steps;

import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.autobudget.AutobudgetAlertsResponse;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.autobudget.AutobudgetAlertsService;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.autobudget.OrdersNotExceededBudgetParams;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.autobudget.OrdersWithCpaWarningsParams;
import ru.yandex.autotests.directapi.darkside.exceptions.DarkSideException;
import ru.yandex.autotests.directapi.darkside.steps.base.BaseJsonRpcSteps;
import ru.yandex.qatools.allure.annotations.Step;

import static ch.lambdaj.Lambda.having;
import static ch.lambdaj.Lambda.on;
import static org.hamcrest.Matchers.allOf;
import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Уведомления автобюджета
 */
public class AutobudgetAlertsSteps extends BaseJsonRpcSteps<AutobudgetAlertsService> {

    @Step(value = "Вызов {method} с параметрами {0}")
    public void ordersNotExceededBudget(OrdersNotExceededBudgetParams params) {

        try {
            AutobudgetAlertsResponse response = service().ordersNotExceededBudget(params);
            assumeThat("не получили ошибку в ответе",
                    response,
                    allOf(
                            having(on(AutobudgetAlertsResponse.class).getSuccess(), equalTo(1)),
                            having(on(AutobudgetAlertsResponse.class).getError(), equalTo(0))
                    ));
        } catch (Throwable throwable) {
            throw new DarkSideException("Не удалось вызвать метод ordersNotExceededBudget", throwable);
        }
    }

    @Step(value = "Вызов {method} с параметрами {0}")
    public void ordersWithCpaWarnings(OrdersWithCpaWarningsParams params) {
        try {
            AutobudgetAlertsResponse response = service().ordersWithCpaWarnings(params);

            assumeThat("не получили ошибку в ответе",
                    response,
                    allOf(
                            having(on(AutobudgetAlertsResponse.class).getSuccess(), equalTo(1)),
                            having(on(AutobudgetAlertsResponse.class).getError(), equalTo(0))
                    ));
        } catch (Throwable throwable) {
            throw new DarkSideException("Не удалось вызвать метод ordersWithCpaWarnings", throwable);
        }

    }

    @Override
    protected AutobudgetAlertsService initService() {
        return client().getServiceWithOneComplexParam(getServiceName(), getClazz());
    }

    @Override
    protected String getServiceName() {
        return AutobudgetAlertsService.SERVICE_NAME;
    }

    @Override
    protected Class<AutobudgetAlertsService> getClazz() {
        return AutobudgetAlertsService.class;
    }
}
