package ru.yandex.autotests.directapi.darkside.steps;

import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.autobudgetoptimizedby.AutobudgetOptimizedByRequest;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.autobudgetoptimizedby.AutobudgetOptimizedByResponse;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.autobudgetoptimizedby.AutobudgetOptimizedByService;
import ru.yandex.autotests.directapi.darkside.steps.base.BaseJsonRpcSteps;
import ru.yandex.qatools.allure.annotations.Step;

import java.util.List;

public class AutobudgetOptimizedBySteps extends BaseJsonRpcSteps<AutobudgetOptimizedByService> {
    @Step("Вызов AutobudgetOptimizedBy.setOrder")
    public List<AutobudgetOptimizedByResponse> setOrder(AutobudgetOptimizedByRequest... datas) {
        return service().setOrder(datas);
    }

    @Step("Вызов AutobudgetOptimizedBy.setOrder")
    public List<AutobudgetOptimizedByResponse> setOrder(String request) {
        return service().setOrder(request);
    }

    @Step("Вызов AutobudgetOptimizedBy.setFilter")
    public List<AutobudgetOptimizedByResponse> setFilter(AutobudgetOptimizedByRequest... datas) {
        return service().setFilter(datas);
    }

    @Step("Вызов AutobudgetOptimizedBy.setFilter")
    public List<AutobudgetOptimizedByResponse> setFilter(String request) {
        return service().setFilter(request);
    }

    @Override
    protected AutobudgetOptimizedByService initService() {
        return client().getServiceWithOneComplexParam(getServiceName(), getClazz());
    }

    @Override
    protected String getServiceName() {
        return AutobudgetOptimizedByService.SERVICE_NAME;
    }

    @Override
    protected Class<AutobudgetOptimizedByService> getClazz() {
        return AutobudgetOptimizedByService.class;
    }
}
