package ru.yandex.autotests.directapi.darkside.steps;

import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.autobudget.AutobudgetPricesService;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.autobudget.AutobudgetPricesSetRequest;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.autobudget.AutobudgetPricesSetResponse;
import ru.yandex.autotests.directapi.darkside.steps.base.BaseJsonRpcSteps;
import ru.yandex.qatools.allure.annotations.Step;

import java.util.Arrays;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanDiffer;

public class AutobudgetSteps extends BaseJsonRpcSteps<AutobudgetPricesService> {

    @Step("Вызов метода AutobudgetPrices.set")
    public void set(AutobudgetPricesSetRequest... params) {
        AutobudgetPricesSetResponse[] responses = service().set(params);
        assertThat("Ответ метода должен быть пустым, иначе значит получили ошибку", responses.length, equalTo(0));
    }

    @Step("Вызов метода AutobudgetPrices.set c ожиданием ошибки {0} {1}")
    public void setWithExpectedError(AutobudgetPricesSetRequest params, int code, String message) {
        AutobudgetPricesSetResponse[] responses = service().set(new AutobudgetPricesSetRequest[]{params});

        AutobudgetPricesSetResponse expectedError = new AutobudgetPricesSetResponse(
                code,
                message,
                params.getGroupExportID(),
                params.getPhraseID()
        );
        assertThat("В ответе метода должен быть один объект", responses.length, equalTo(1));
        assertThat("Ошибка не совпадает с ожидаемым", responses[0], beanEquals(expectedError));
    }

    @Step("Вызов метода AutobudgetPrices.set c ожиданием ошибок")
    public void setWithExpectedErrors(AutobudgetPricesSetRequest[] params, AutobudgetPricesSetResponse... errors) {
        AutobudgetPricesSetResponse[] responses = service().set(params);
        Arrays.sort(responses);
        Arrays.sort(errors);
        assertThat("Ошибки не совпадают с ожидаемым", responses, beanDiffer(errors));
    }

    @Override
    protected AutobudgetPricesService initService() {
        return client().getServiceWithOneComplexParam(getServiceName(), getClazz());
    }

    @Override
    protected String getServiceName() {
        return AutobudgetPricesService.SERVICE_NAME;
    }

    @Override
    protected Class<AutobudgetPricesService> getClazz() {
        return AutobudgetPricesService.class;
    }
}
