package ru.yandex.autotests.directapi.darkside.steps;

import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.balanceclient.BalanceClientJSONResponse;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.balanceclient.BalanceClientService;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.balanceclient.NotifyAgencyAdditionalCurrenciesJSONRequest;
import ru.yandex.autotests.directapi.darkside.steps.base.BaseJsonRestSteps;
import ru.yandex.autotests.irt.testutils.beandiffer2.beanfield.BeanFieldPath;
import ru.yandex.autotests.irt.testutils.beandiffer2.comparestrategy.defaultcomparestrategy.DefaultCompareStrategies;
import ru.yandex.qatools.allure.annotations.Step;

import static org.hamcrest.Matchers.containsString;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

public class BalanceClientNotifyAgencyAdditionalCurrenciesJsonSteps extends BaseJsonRestSteps {
    @Step("JSON-REST BalanceClient:NotifyAgencyAdditionalCurrencies")
    public BalanceClientJSONResponse notifyAgencyAdditionalCurrenciesNoErrors(
            NotifyAgencyAdditionalCurrenciesJSONRequest request)
    {
        return performRequest(request);
    }

    @Step("JSON-REST BalanceClient:NotifyAgencyAdditionalCurrencies" +
            " expecting error with httpCode: {1}, errorCode: {2}, errorMessage: {3}")
    public void notifyAgencyAdditionalCurrenciesExpectErrors(NotifyAgencyAdditionalCurrenciesJSONRequest request,
            int httpCode, int errorCode, String errorMessage)
    {
        BalanceClientJSONResponse response = performRequest(request, httpCode);
        BalanceClientJSONResponse expectedResponse = new BalanceClientJSONResponse()
                .withCode(errorCode)
                .withErrorMessage(errorMessage);

        assertThat("Получен ожидаемый ответ с ошибкой",
                response,
                beanDiffer(expectedResponse).useCompareStrategy(
                        DefaultCompareStrategies
                                .allFields()
                                .forFields(BeanFieldPath.newPath("errorMessage"))
                                .useMatcher(containsString(expectedResponse.getErrorMessage())))
        );
    }

    @Override
    protected String getServiceName() {
        return BalanceClientService.SERVICE_NAME;
    }

    @Override
    protected String getMethodName() {
        return BalanceClientService.NOTIFY_AGENCY_ADDITIONAL_CURRENCIES_METHOD_NAME;
    }
}
