package ru.yandex.autotests.directapi.darkside.steps;

import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.balancerevise.BalanceReviseService;
import ru.yandex.autotests.directapi.darkside.steps.base.BaseJsonRpcSteps;
import ru.yandex.qatools.allure.annotations.Step;

import java.util.List;

public class BalanceReviseSteps extends BaseJsonRpcSteps<BalanceReviseService> {

    @Step("jsonRpc=getPaidCidsNotInBS (получение информации о кампаниях с деньгами, но не в БК)")
    public List<Long> getPaidCidsNotInBS() {
        return service().getPaidCidsNotInBS().getResult();
    }

    @Override
    protected String getServiceName() {
        return BalanceReviseService.SERVICE_NAME;
    }

    @Override
    protected Class<BalanceReviseService> getClazz() {
        return BalanceReviseService.class;
    }
}
