package ru.yandex.autotests.directapi.darkside.steps;

import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.bannerland.BannerLandResponse;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.bannerland.BannerLandService;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.bannerland.GenerateStatus;
import ru.yandex.autotests.directapi.darkside.steps.base.BaseJsonRpcSteps;
import ru.yandex.qatools.allure.annotations.Step;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by ssdmitriev on 01.12.15.
 */
public class BannerLandSteps extends BaseJsonRpcSteps<BannerLandService> {

    @Step("Вызов BannerLand.setStatusForAdGroups. cid = {0}, groupId = {1}, status = {2}")
    public BannerLandResponse setStatusForAdGroups(Long cid, Long groupId, GenerateStatus status) {
        Map<Long, GenerateStatus> adGroups = new HashMap<>();
        adGroups.put(groupId, status);
        return setStatusForAdGroups(cid, adGroups);
    }

    @Step("Вызов BannerLand.setStatusForAdGroups. cid = {0}")
    public BannerLandResponse setStatusForAdGroups(Long cid, Map<Long, GenerateStatus> adGroups) {
        Map<Long, Map<Long, GenerateStatus>> orders = new HashMap<>();
        orders.put(cid, adGroups);
        return service().setStatusForAdGroups(orders);
    }

    @Step("Вызов BannerLand.setStatusForAdGroups")
    public BannerLandResponse setStatusForAdGroups(Map<Long, Map<Long, GenerateStatus>> orders) {
        return service().setStatusForAdGroups(orders);
    }

    @Override
    protected String getServiceName() {
        return BannerLandService.SERVICE_NAME;
    }

    @Override
    protected Class<BannerLandService> getClazz() {
        return BannerLandService.class;
    }

    @Override
    protected BannerLandService initService() {
        return client().getServiceWithOneComplexParam(getServiceName(), getClazz());
    }
}
