package ru.yandex.autotests.directapi.darkside.steps;

import java.util.HashMap;
import java.util.Map;

import ru.yandex.autotests.direct.utils.BaseSteps;
import ru.yandex.autotests.direct.utils.clients.blackbox.BlackboxClient;
import ru.yandex.autotests.directapi.darkside.connection.BlackboxConfig;
import ru.yandex.autotests.direct.utils.clients.blackbox.PassportUserInfo;
import ru.yandex.qatools.allure.annotations.Step;

/**
 * Степы для работы с Blackbox-ом
 *
 * @author egorovmv
 */
public final class BlackboxSteps extends BaseSteps<BlackboxConfig> {
    private BlackboxClient blackboxClient;
    private Map<String, PassportUserInfo> cache;

    @Override
    protected void init(BlackboxConfig context) {
        super.init(context);
        blackboxClient = new BlackboxClient(context.getHost());
        cache = new HashMap<>();
    }

    /**
     * Вернуть данные о пользователе из паспорта. Данные кешируются
     */
    @Step("Получение данных о пользователе из Blackbox-а: login = {0}")
    public PassportUserInfo getUserInfoByLogin(String login) {
        return cache.computeIfAbsent(login, blackboxClient::getUserInfoByLogin);
    }
}
